/*
 * Decompiled with CFR 0.152.
 */
package com.pdfcrowd;

import com.pdfcrowd.Base64Utils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public final class Pdfcrowd {
    private static final String HOST = System.getenv("PDFCROWD_HOST") != null ? System.getenv("PDFCROWD_HOST") : "api.pdfcrowd.com";
    private static final String MULTIPART_BOUNDARY = "----------ThIs_Is_tHe_bOUnDary_$";
    public static final String CLIENT_VERSION = "6.5.3";

    static String createInvalidValueMessage(Object value, String field, String converter, String hint, String id) {
        String message = String.format("400.311 - Invalid value '%s' for the '%s' option.", value, field);
        if (hint != null) {
            message = message + " " + hint;
        }
        return message + " " + String.format("Documentation link: https://www.pdfcrowd.com/api/%s-java/ref/#%s", converter, id);
    }

    public static final class PdfToImageClient {
        private ConnectionHelper helper;
        private HashMap<String, String> fields = new HashMap();
        private HashMap<String, String> files = new HashMap();
        private HashMap<String, byte[]> rawData = new HashMap();
        private int fileId = 1;

        public PdfToImageClient(String userName, String apiKey) {
            this.helper = new ConnectionHelper(userName, apiKey);
            this.fields.put("input_format", "pdf");
            this.fields.put("output_format", "png");
        }

        public byte[] convertUrl(String url) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "convertUrl", "pdf-to-image", "Supported protocols are http:// and https://.", "convert_url"), 470);
            }
            this.fields.put("url", url);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertUrlToStream(String url, OutputStream outStream) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "convertUrlToStream::url", "pdf-to-image", "Supported protocols are http:// and https://.", "convert_url_to_stream"), 470);
            }
            this.fields.put("url", url);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertUrlToFile(String url, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertUrlToFile::file_path", "pdf-to-image", "The string must not be empty.", "convert_url_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertUrlToStream(url, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertFile(String file) {
            if (new File(file).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(file, "convertFile", "pdf-to-image", "The file must exist and not be empty.", "convert_file"), 470);
            }
            this.files.put("file", file);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertFileToStream(String file, OutputStream outStream) {
            if (new File(file).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(file, "convertFileToStream::file", "pdf-to-image", "The file must exist and not be empty.", "convert_file_to_stream"), 470);
            }
            this.files.put("file", file);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertFileToFile(String file, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertFileToFile::file_path", "pdf-to-image", "The string must not be empty.", "convert_file_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertFileToStream(file, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertRawData(byte[] data) {
            this.rawData.put("file", data);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertRawDataToStream(byte[] data, OutputStream outStream) {
            this.rawData.put("file", data);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertRawDataToFile(byte[] data, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertRawDataToFile::file_path", "pdf-to-image", "The string must not be empty.", "convert_raw_data_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertRawDataToStream(data, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertStream(InputStream inStream) throws IOException {
            this.rawData.put("stream", ConnectionHelper.getBytes(inStream));
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertStreamToStream(InputStream inStream, OutputStream outStream) throws IOException {
            this.rawData.put("stream", ConnectionHelper.getBytes(inStream));
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertStreamToFile(InputStream inStream, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertStreamToFile::file_path", "pdf-to-image", "The string must not be empty.", "convert_stream_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertStreamToStream(inStream, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public PdfToImageClient setOutputFormat(String outputFormat) {
            if (!outputFormat.matches("(?i)^(png|jpg|gif|tiff|bmp|ico|ppm|pgm|pbm|pnm|psb|pct|ras|tga|sgi|sun|webp)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(outputFormat, "setOutputFormat", "pdf-to-image", "Allowed values are png, jpg, gif, tiff, bmp, ico, ppm, pgm, pbm, pnm, psb, pct, ras, tga, sgi, sun, webp.", "set_output_format"), 470);
            }
            this.fields.put("output_format", outputFormat);
            return this;
        }

        public PdfToImageClient setPdfPassword(String password) {
            this.fields.put("pdf_password", password);
            return this;
        }

        public PdfToImageClient setPrintPageRange(String pages) {
            if (!pages.matches("^(?:\\s*(?:\\d+|(?:\\d*\\s*\\-\\s*\\d+)|(?:\\d+\\s*\\-\\s*\\d*))\\s*,\\s*)*\\s*(?:\\d+|(?:\\d*\\s*\\-\\s*\\d+)|(?:\\d+\\s*\\-\\s*\\d*))\\s*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(pages, "setPrintPageRange", "pdf-to-image", "A comma separated list of page numbers or ranges.", "set_print_page_range"), 470);
            }
            this.fields.put("print_page_range", pages);
            return this;
        }

        public PdfToImageClient setDpi(int dpi) {
            this.fields.put("dpi", Integer.toString(dpi));
            return this;
        }

        public boolean isZippedOutput() {
            return "true".equals(this.fields.get("force_zip")) || this.getPageCount() > 1;
        }

        public PdfToImageClient setForceZip(boolean value) {
            this.fields.put("force_zip", value ? "true" : null);
            return this;
        }

        public PdfToImageClient setUseCropbox(boolean value) {
            this.fields.put("use_cropbox", value ? "true" : null);
            return this;
        }

        public PdfToImageClient setCropAreaX(int x) {
            if (x < 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(x, "setCropAreaX", "pdf-to-image", "Must be a positive integer or 0.", "set_crop_area_x"), 470);
            }
            this.fields.put("crop_area_x", Integer.toString(x));
            return this;
        }

        public PdfToImageClient setCropAreaY(int y) {
            if (y < 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(y, "setCropAreaY", "pdf-to-image", "Must be a positive integer or 0.", "set_crop_area_y"), 470);
            }
            this.fields.put("crop_area_y", Integer.toString(y));
            return this;
        }

        public PdfToImageClient setCropAreaWidth(int width) {
            if (width < 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(width, "setCropAreaWidth", "pdf-to-image", "Must be a positive integer or 0.", "set_crop_area_width"), 470);
            }
            this.fields.put("crop_area_width", Integer.toString(width));
            return this;
        }

        public PdfToImageClient setCropAreaHeight(int height) {
            if (height < 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(height, "setCropAreaHeight", "pdf-to-image", "Must be a positive integer or 0.", "set_crop_area_height"), 470);
            }
            this.fields.put("crop_area_height", Integer.toString(height));
            return this;
        }

        public PdfToImageClient setCropArea(int x, int y, int width, int height) {
            this.setCropAreaX(x);
            this.setCropAreaY(y);
            this.setCropAreaWidth(width);
            this.setCropAreaHeight(height);
            return this;
        }

        public PdfToImageClient setUseGrayscale(boolean value) {
            this.fields.put("use_grayscale", value ? "true" : null);
            return this;
        }

        public PdfToImageClient setDebugLog(boolean value) {
            this.fields.put("debug_log", value ? "true" : null);
            return this;
        }

        public String getDebugLogUrl() {
            return this.helper.getDebugLogUrl();
        }

        public int getRemainingCreditCount() {
            return this.helper.getRemainingCreditCount();
        }

        public int getConsumedCreditCount() {
            return this.helper.getConsumedCreditCount();
        }

        public String getJobId() {
            return this.helper.getJobId();
        }

        public int getPageCount() {
            return this.helper.getPageCount();
        }

        public int getOutputSize() {
            return this.helper.getOutputSize();
        }

        public String getVersion() {
            return String.format("client %s, API v2, converter %s", Pdfcrowd.CLIENT_VERSION, this.helper.getConverterVersion());
        }

        public PdfToImageClient setTag(String tag) {
            this.fields.put("tag", tag);
            return this;
        }

        public PdfToImageClient setHttpProxy(String proxy) {
            if (!proxy.matches("(?i)^([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z0-9]{1,}:\\d+$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(proxy, "setHttpProxy", "pdf-to-image", "The value must have format DOMAIN_OR_IP_ADDRESS:PORT.", "set_http_proxy"), 470);
            }
            this.fields.put("http_proxy", proxy);
            return this;
        }

        public PdfToImageClient setHttpsProxy(String proxy) {
            if (!proxy.matches("(?i)^([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z0-9]{1,}:\\d+$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(proxy, "setHttpsProxy", "pdf-to-image", "The value must have format DOMAIN_OR_IP_ADDRESS:PORT.", "set_https_proxy"), 470);
            }
            this.fields.put("https_proxy", proxy);
            return this;
        }

        public PdfToImageClient setUseHttp(boolean value) {
            this.helper.setUseHttp(value);
            return this;
        }

        public PdfToImageClient setClientUserAgent(String agent) {
            this.helper.setUserAgent(agent);
            return this;
        }

        public PdfToImageClient setUserAgent(String agent) {
            this.helper.setUserAgent(agent);
            return this;
        }

        public PdfToImageClient setProxy(String host, int port, String userName, String password) {
            this.helper.setProxy(host, port, userName, password);
            return this;
        }

        public PdfToImageClient setRetryCount(int count) {
            this.helper.setRetryCount(count);
            return this;
        }
    }

    public static final class PdfToTextClient {
        private ConnectionHelper helper;
        private HashMap<String, String> fields = new HashMap();
        private HashMap<String, String> files = new HashMap();
        private HashMap<String, byte[]> rawData = new HashMap();
        private int fileId = 1;

        public PdfToTextClient(String userName, String apiKey) {
            this.helper = new ConnectionHelper(userName, apiKey);
            this.fields.put("input_format", "pdf");
            this.fields.put("output_format", "txt");
        }

        public byte[] convertUrl(String url) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "convertUrl", "pdf-to-text", "Supported protocols are http:// and https://.", "convert_url"), 470);
            }
            this.fields.put("url", url);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertUrlToStream(String url, OutputStream outStream) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "convertUrlToStream::url", "pdf-to-text", "Supported protocols are http:// and https://.", "convert_url_to_stream"), 470);
            }
            this.fields.put("url", url);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertUrlToFile(String url, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertUrlToFile::file_path", "pdf-to-text", "The string must not be empty.", "convert_url_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertUrlToStream(url, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertFile(String file) {
            if (new File(file).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(file, "convertFile", "pdf-to-text", "The file must exist and not be empty.", "convert_file"), 470);
            }
            this.files.put("file", file);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertFileToStream(String file, OutputStream outStream) {
            if (new File(file).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(file, "convertFileToStream::file", "pdf-to-text", "The file must exist and not be empty.", "convert_file_to_stream"), 470);
            }
            this.files.put("file", file);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertFileToFile(String file, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertFileToFile::file_path", "pdf-to-text", "The string must not be empty.", "convert_file_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertFileToStream(file, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertRawData(byte[] data) {
            this.rawData.put("file", data);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertRawDataToStream(byte[] data, OutputStream outStream) {
            this.rawData.put("file", data);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertRawDataToFile(byte[] data, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertRawDataToFile::file_path", "pdf-to-text", "The string must not be empty.", "convert_raw_data_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertRawDataToStream(data, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertStream(InputStream inStream) throws IOException {
            this.rawData.put("stream", ConnectionHelper.getBytes(inStream));
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertStreamToStream(InputStream inStream, OutputStream outStream) throws IOException {
            this.rawData.put("stream", ConnectionHelper.getBytes(inStream));
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertStreamToFile(InputStream inStream, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertStreamToFile::file_path", "pdf-to-text", "The string must not be empty.", "convert_stream_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertStreamToStream(inStream, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public PdfToTextClient setPdfPassword(String password) {
            this.fields.put("pdf_password", password);
            return this;
        }

        public PdfToTextClient setPrintPageRange(String pages) {
            if (!pages.matches("^(?:\\s*(?:\\d+|(?:\\d*\\s*\\-\\s*\\d+)|(?:\\d+\\s*\\-\\s*\\d*))\\s*,\\s*)*\\s*(?:\\d+|(?:\\d*\\s*\\-\\s*\\d+)|(?:\\d+\\s*\\-\\s*\\d*))\\s*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(pages, "setPrintPageRange", "pdf-to-text", "A comma separated list of page numbers or ranges.", "set_print_page_range"), 470);
            }
            this.fields.put("print_page_range", pages);
            return this;
        }

        public PdfToTextClient setNoLayout(boolean value) {
            this.fields.put("no_layout", value ? "true" : null);
            return this;
        }

        public PdfToTextClient setEol(String eol) {
            if (!eol.matches("(?i)^(unix|dos|mac)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(eol, "setEol", "pdf-to-text", "Allowed values are unix, dos, mac.", "set_eol"), 470);
            }
            this.fields.put("eol", eol);
            return this;
        }

        public PdfToTextClient setPageBreakMode(String mode) {
            if (!mode.matches("(?i)^(none|default|custom)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(mode, "setPageBreakMode", "pdf-to-text", "Allowed values are none, default, custom.", "set_page_break_mode"), 470);
            }
            this.fields.put("page_break_mode", mode);
            return this;
        }

        public PdfToTextClient setCustomPageBreak(String pageBreak) {
            this.fields.put("custom_page_break", pageBreak);
            return this;
        }

        public PdfToTextClient setParagraphMode(String mode) {
            if (!mode.matches("(?i)^(none|bounding-box|characters)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(mode, "setParagraphMode", "pdf-to-text", "Allowed values are none, bounding-box, characters.", "set_paragraph_mode"), 470);
            }
            this.fields.put("paragraph_mode", mode);
            return this;
        }

        public PdfToTextClient setLineSpacingThreshold(String threshold) {
            if (!threshold.matches("(?i)^0$|^[0-9]+%$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(threshold, "setLineSpacingThreshold", "pdf-to-text", "The value must be a positive integer percentage.", "set_line_spacing_threshold"), 470);
            }
            this.fields.put("line_spacing_threshold", threshold);
            return this;
        }

        public PdfToTextClient setRemoveHyphenation(boolean value) {
            this.fields.put("remove_hyphenation", value ? "true" : null);
            return this;
        }

        public PdfToTextClient setRemoveEmptyLines(boolean value) {
            this.fields.put("remove_empty_lines", value ? "true" : null);
            return this;
        }

        public PdfToTextClient setCropAreaX(int x) {
            if (x < 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(x, "setCropAreaX", "pdf-to-text", "Must be a positive integer or 0.", "set_crop_area_x"), 470);
            }
            this.fields.put("crop_area_x", Integer.toString(x));
            return this;
        }

        public PdfToTextClient setCropAreaY(int y) {
            if (y < 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(y, "setCropAreaY", "pdf-to-text", "Must be a positive integer or 0.", "set_crop_area_y"), 470);
            }
            this.fields.put("crop_area_y", Integer.toString(y));
            return this;
        }

        public PdfToTextClient setCropAreaWidth(int width) {
            if (width < 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(width, "setCropAreaWidth", "pdf-to-text", "Must be a positive integer or 0.", "set_crop_area_width"), 470);
            }
            this.fields.put("crop_area_width", Integer.toString(width));
            return this;
        }

        public PdfToTextClient setCropAreaHeight(int height) {
            if (height < 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(height, "setCropAreaHeight", "pdf-to-text", "Must be a positive integer or 0.", "set_crop_area_height"), 470);
            }
            this.fields.put("crop_area_height", Integer.toString(height));
            return this;
        }

        public PdfToTextClient setCropArea(int x, int y, int width, int height) {
            this.setCropAreaX(x);
            this.setCropAreaY(y);
            this.setCropAreaWidth(width);
            this.setCropAreaHeight(height);
            return this;
        }

        public PdfToTextClient setDebugLog(boolean value) {
            this.fields.put("debug_log", value ? "true" : null);
            return this;
        }

        public String getDebugLogUrl() {
            return this.helper.getDebugLogUrl();
        }

        public int getRemainingCreditCount() {
            return this.helper.getRemainingCreditCount();
        }

        public int getConsumedCreditCount() {
            return this.helper.getConsumedCreditCount();
        }

        public String getJobId() {
            return this.helper.getJobId();
        }

        public int getPageCount() {
            return this.helper.getPageCount();
        }

        public int getOutputSize() {
            return this.helper.getOutputSize();
        }

        public String getVersion() {
            return String.format("client %s, API v2, converter %s", Pdfcrowd.CLIENT_VERSION, this.helper.getConverterVersion());
        }

        public PdfToTextClient setTag(String tag) {
            this.fields.put("tag", tag);
            return this;
        }

        public PdfToTextClient setHttpProxy(String proxy) {
            if (!proxy.matches("(?i)^([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z0-9]{1,}:\\d+$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(proxy, "setHttpProxy", "pdf-to-text", "The value must have format DOMAIN_OR_IP_ADDRESS:PORT.", "set_http_proxy"), 470);
            }
            this.fields.put("http_proxy", proxy);
            return this;
        }

        public PdfToTextClient setHttpsProxy(String proxy) {
            if (!proxy.matches("(?i)^([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z0-9]{1,}:\\d+$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(proxy, "setHttpsProxy", "pdf-to-text", "The value must have format DOMAIN_OR_IP_ADDRESS:PORT.", "set_https_proxy"), 470);
            }
            this.fields.put("https_proxy", proxy);
            return this;
        }

        public PdfToTextClient setUseHttp(boolean value) {
            this.helper.setUseHttp(value);
            return this;
        }

        public PdfToTextClient setClientUserAgent(String agent) {
            this.helper.setUserAgent(agent);
            return this;
        }

        public PdfToTextClient setUserAgent(String agent) {
            this.helper.setUserAgent(agent);
            return this;
        }

        public PdfToTextClient setProxy(String host, int port, String userName, String password) {
            this.helper.setProxy(host, port, userName, password);
            return this;
        }

        public PdfToTextClient setRetryCount(int count) {
            this.helper.setRetryCount(count);
            return this;
        }
    }

    public static final class PdfToHtmlClient {
        private ConnectionHelper helper;
        private HashMap<String, String> fields = new HashMap();
        private HashMap<String, String> files = new HashMap();
        private HashMap<String, byte[]> rawData = new HashMap();
        private int fileId = 1;

        public PdfToHtmlClient(String userName, String apiKey) {
            this.helper = new ConnectionHelper(userName, apiKey);
            this.fields.put("input_format", "pdf");
            this.fields.put("output_format", "html");
        }

        public byte[] convertUrl(String url) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "convertUrl", "pdf-to-html", "Supported protocols are http:// and https://.", "convert_url"), 470);
            }
            this.fields.put("url", url);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertUrlToStream(String url, OutputStream outStream) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "convertUrlToStream::url", "pdf-to-html", "Supported protocols are http:// and https://.", "convert_url_to_stream"), 470);
            }
            this.fields.put("url", url);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertUrlToFile(String url, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertUrlToFile::file_path", "pdf-to-html", "The string must not be empty.", "convert_url_to_file"), 470);
            }
            if (!this.isOutputTypeValid(filePath)) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertUrlToFile::file_path", "pdf-to-html", "The converter generates an HTML or ZIP file. If ZIP file is generated, the file path must have a ZIP or zip extension.", "convert_url_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertUrlToStream(url, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertFile(String file) {
            if (new File(file).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(file, "convertFile", "pdf-to-html", "The file must exist and not be empty.", "convert_file"), 470);
            }
            this.files.put("file", file);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertFileToStream(String file, OutputStream outStream) {
            if (new File(file).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(file, "convertFileToStream::file", "pdf-to-html", "The file must exist and not be empty.", "convert_file_to_stream"), 470);
            }
            this.files.put("file", file);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertFileToFile(String file, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertFileToFile::file_path", "pdf-to-html", "The string must not be empty.", "convert_file_to_file"), 470);
            }
            if (!this.isOutputTypeValid(filePath)) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertFileToFile::file_path", "pdf-to-html", "The converter generates an HTML or ZIP file. If ZIP file is generated, the file path must have a ZIP or zip extension.", "convert_file_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertFileToStream(file, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertRawData(byte[] data) {
            this.rawData.put("file", data);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertRawDataToStream(byte[] data, OutputStream outStream) {
            this.rawData.put("file", data);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertRawDataToFile(byte[] data, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertRawDataToFile::file_path", "pdf-to-html", "The string must not be empty.", "convert_raw_data_to_file"), 470);
            }
            if (!this.isOutputTypeValid(filePath)) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertRawDataToFile::file_path", "pdf-to-html", "The converter generates an HTML or ZIP file. If ZIP file is generated, the file path must have a ZIP or zip extension.", "convert_raw_data_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertRawDataToStream(data, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertStream(InputStream inStream) throws IOException {
            this.rawData.put("stream", ConnectionHelper.getBytes(inStream));
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertStreamToStream(InputStream inStream, OutputStream outStream) throws IOException {
            this.rawData.put("stream", ConnectionHelper.getBytes(inStream));
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertStreamToFile(InputStream inStream, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertStreamToFile::file_path", "pdf-to-html", "The string must not be empty.", "convert_stream_to_file"), 470);
            }
            if (!this.isOutputTypeValid(filePath)) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertStreamToFile::file_path", "pdf-to-html", "The converter generates an HTML or ZIP file. If ZIP file is generated, the file path must have a ZIP or zip extension.", "convert_stream_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertStreamToStream(inStream, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public PdfToHtmlClient setPdfPassword(String password) {
            this.fields.put("pdf_password", password);
            return this;
        }

        public PdfToHtmlClient setScaleFactor(int factor) {
            if (factor <= 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(factor, "setScaleFactor", "pdf-to-html", "Must be a positive integer.", "set_scale_factor"), 470);
            }
            this.fields.put("scale_factor", Integer.toString(factor));
            return this;
        }

        public PdfToHtmlClient setPrintPageRange(String pages) {
            if (!pages.matches("^(?:\\s*(?:\\d+|(?:\\d*\\s*\\-\\s*\\d+)|(?:\\d+\\s*\\-\\s*\\d*))\\s*,\\s*)*\\s*(?:\\d+|(?:\\d*\\s*\\-\\s*\\d+)|(?:\\d+\\s*\\-\\s*\\d*))\\s*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(pages, "setPrintPageRange", "pdf-to-html", "A comma separated list of page numbers or ranges.", "set_print_page_range"), 470);
            }
            this.fields.put("print_page_range", pages);
            return this;
        }

        public PdfToHtmlClient setDpi(int dpi) {
            this.fields.put("dpi", Integer.toString(dpi));
            return this;
        }

        public PdfToHtmlClient setImageMode(String mode) {
            if (!mode.matches("(?i)^(embed|separate|none)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(mode, "setImageMode", "pdf-to-html", "Allowed values are embed, separate, none.", "set_image_mode"), 470);
            }
            this.fields.put("image_mode", mode);
            return this;
        }

        public PdfToHtmlClient setImageFormat(String imageFormat) {
            if (!imageFormat.matches("(?i)^(png|jpg|svg)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(imageFormat, "setImageFormat", "pdf-to-html", "Allowed values are png, jpg, svg.", "set_image_format"), 470);
            }
            this.fields.put("image_format", imageFormat);
            return this;
        }

        public PdfToHtmlClient setCssMode(String mode) {
            if (!mode.matches("(?i)^(embed|separate)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(mode, "setCssMode", "pdf-to-html", "Allowed values are embed, separate.", "set_css_mode"), 470);
            }
            this.fields.put("css_mode", mode);
            return this;
        }

        public PdfToHtmlClient setFontMode(String mode) {
            if (!mode.matches("(?i)^(embed|separate)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(mode, "setFontMode", "pdf-to-html", "Allowed values are embed, separate.", "set_font_mode"), 470);
            }
            this.fields.put("font_mode", mode);
            return this;
        }

        public PdfToHtmlClient setType3Mode(String mode) {
            if (!mode.matches("(?i)^(raster|convert)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(mode, "setType3Mode", "pdf-to-html", "Allowed values are raster, convert.", "set_type3_mode"), 470);
            }
            this.fields.put("type3_mode", mode);
            return this;
        }

        public PdfToHtmlClient setSplitLigatures(boolean value) {
            this.fields.put("split_ligatures", value ? "true" : null);
            return this;
        }

        public PdfToHtmlClient setCustomCss(String css) {
            if (css == null || css.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(css, "setCustomCss", "pdf-to-html", "The string must not be empty.", "set_custom_css"), 470);
            }
            this.fields.put("custom_css", css);
            return this;
        }

        public PdfToHtmlClient setHtmlNamespace(String prefix) {
            if (!prefix.matches("(?i)^[a-z_][a-z0-9_:-]*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(prefix, "setHtmlNamespace", "pdf-to-html", "Start with a letter or underscore, and use only letters, numbers, hyphens, underscores, or colons.", "set_html_namespace"), 470);
            }
            this.fields.put("html_namespace", prefix);
            return this;
        }

        public boolean isZippedOutput() {
            return "separate".equals(this.fields.get("image_mode")) || "separate".equals(this.fields.get("css_mode")) || "separate".equals(this.fields.get("font_mode")) || "true".equals(this.fields.get("force_zip"));
        }

        public PdfToHtmlClient setForceZip(boolean value) {
            this.fields.put("force_zip", value ? "true" : null);
            return this;
        }

        public PdfToHtmlClient setTitle(String title) {
            this.fields.put("title", title);
            return this;
        }

        public PdfToHtmlClient setSubject(String subject) {
            this.fields.put("subject", subject);
            return this;
        }

        public PdfToHtmlClient setAuthor(String author) {
            this.fields.put("author", author);
            return this;
        }

        public PdfToHtmlClient setKeywords(String keywords) {
            this.fields.put("keywords", keywords);
            return this;
        }

        public PdfToHtmlClient setDebugLog(boolean value) {
            this.fields.put("debug_log", value ? "true" : null);
            return this;
        }

        public String getDebugLogUrl() {
            return this.helper.getDebugLogUrl();
        }

        public int getRemainingCreditCount() {
            return this.helper.getRemainingCreditCount();
        }

        public int getConsumedCreditCount() {
            return this.helper.getConsumedCreditCount();
        }

        public String getJobId() {
            return this.helper.getJobId();
        }

        public int getPageCount() {
            return this.helper.getPageCount();
        }

        public int getOutputSize() {
            return this.helper.getOutputSize();
        }

        public String getVersion() {
            return String.format("client %s, API v2, converter %s", Pdfcrowd.CLIENT_VERSION, this.helper.getConverterVersion());
        }

        public PdfToHtmlClient setTag(String tag) {
            this.fields.put("tag", tag);
            return this;
        }

        public PdfToHtmlClient setHttpProxy(String proxy) {
            if (!proxy.matches("(?i)^([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z0-9]{1,}:\\d+$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(proxy, "setHttpProxy", "pdf-to-html", "The value must have format DOMAIN_OR_IP_ADDRESS:PORT.", "set_http_proxy"), 470);
            }
            this.fields.put("http_proxy", proxy);
            return this;
        }

        public PdfToHtmlClient setHttpsProxy(String proxy) {
            if (!proxy.matches("(?i)^([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z0-9]{1,}:\\d+$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(proxy, "setHttpsProxy", "pdf-to-html", "The value must have format DOMAIN_OR_IP_ADDRESS:PORT.", "set_https_proxy"), 470);
            }
            this.fields.put("https_proxy", proxy);
            return this;
        }

        public PdfToHtmlClient setConverterVersion(String version) {
            if (!version.matches("(?i)^(24.04|20.10|18.10|latest)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(version, "setConverterVersion", "pdf-to-html", "Allowed values are 24.04, 20.10, 18.10, latest.", "set_converter_version"), 470);
            }
            this.helper.setConverterVersion(version);
            return this;
        }

        public PdfToHtmlClient setUseHttp(boolean value) {
            this.helper.setUseHttp(value);
            return this;
        }

        public PdfToHtmlClient setClientUserAgent(String agent) {
            this.helper.setUserAgent(agent);
            return this;
        }

        public PdfToHtmlClient setUserAgent(String agent) {
            this.helper.setUserAgent(agent);
            return this;
        }

        public PdfToHtmlClient setProxy(String host, int port, String userName, String password) {
            this.helper.setProxy(host, port, userName, password);
            return this;
        }

        public PdfToHtmlClient setRetryCount(int count) {
            this.helper.setRetryCount(count);
            return this;
        }

        private boolean isOutputTypeValid(String file_path) {
            String extension = "";
            int i = file_path.lastIndexOf(46);
            if (i > 0) {
                extension = file_path.substring(i);
            }
            return extension.equals(".zip") == this.isZippedOutput();
        }
    }

    public static final class ImageToPdfClient {
        private ConnectionHelper helper;
        private HashMap<String, String> fields = new HashMap();
        private HashMap<String, String> files = new HashMap();
        private HashMap<String, byte[]> rawData = new HashMap();
        private int fileId = 1;

        public ImageToPdfClient(String userName, String apiKey) {
            this.helper = new ConnectionHelper(userName, apiKey);
            this.fields.put("input_format", "image");
            this.fields.put("output_format", "pdf");
        }

        public byte[] convertUrl(String url) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "convertUrl", "image-to-pdf", "Supported protocols are http:// and https://.", "convert_url"), 470);
            }
            this.fields.put("url", url);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertUrlToStream(String url, OutputStream outStream) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "convertUrlToStream::url", "image-to-pdf", "Supported protocols are http:// and https://.", "convert_url_to_stream"), 470);
            }
            this.fields.put("url", url);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertUrlToFile(String url, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertUrlToFile::file_path", "image-to-pdf", "The string must not be empty.", "convert_url_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertUrlToStream(url, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertFile(String file) {
            if (new File(file).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(file, "convertFile", "image-to-pdf", "The file must exist and not be empty.", "convert_file"), 470);
            }
            this.files.put("file", file);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertFileToStream(String file, OutputStream outStream) {
            if (new File(file).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(file, "convertFileToStream::file", "image-to-pdf", "The file must exist and not be empty.", "convert_file_to_stream"), 470);
            }
            this.files.put("file", file);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertFileToFile(String file, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertFileToFile::file_path", "image-to-pdf", "The string must not be empty.", "convert_file_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertFileToStream(file, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertRawData(byte[] data) {
            this.rawData.put("file", data);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertRawDataToStream(byte[] data, OutputStream outStream) {
            this.rawData.put("file", data);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertRawDataToFile(byte[] data, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertRawDataToFile::file_path", "image-to-pdf", "The string must not be empty.", "convert_raw_data_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertRawDataToStream(data, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertStream(InputStream inStream) throws IOException {
            this.rawData.put("stream", ConnectionHelper.getBytes(inStream));
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertStreamToStream(InputStream inStream, OutputStream outStream) throws IOException {
            this.rawData.put("stream", ConnectionHelper.getBytes(inStream));
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertStreamToFile(InputStream inStream, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertStreamToFile::file_path", "image-to-pdf", "The string must not be empty.", "convert_stream_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertStreamToStream(inStream, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public ImageToPdfClient setResize(String resize) {
            this.fields.put("resize", resize);
            return this;
        }

        public ImageToPdfClient setRotate(String rotate) {
            this.fields.put("rotate", rotate);
            return this;
        }

        public ImageToPdfClient setCropAreaX(String x) {
            if (!x.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(x, "setCropAreaX", "image-to-pdf", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_crop_area_x"), 470);
            }
            this.fields.put("crop_area_x", x);
            return this;
        }

        public ImageToPdfClient setCropAreaY(String y) {
            if (!y.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(y, "setCropAreaY", "image-to-pdf", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_crop_area_y"), 470);
            }
            this.fields.put("crop_area_y", y);
            return this;
        }

        public ImageToPdfClient setCropAreaWidth(String width) {
            if (!width.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(width, "setCropAreaWidth", "image-to-pdf", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_crop_area_width"), 470);
            }
            this.fields.put("crop_area_width", width);
            return this;
        }

        public ImageToPdfClient setCropAreaHeight(String height) {
            if (!height.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(height, "setCropAreaHeight", "image-to-pdf", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_crop_area_height"), 470);
            }
            this.fields.put("crop_area_height", height);
            return this;
        }

        public ImageToPdfClient setCropArea(String x, String y, String width, String height) {
            this.setCropAreaX(x);
            this.setCropAreaY(y);
            this.setCropAreaWidth(width);
            this.setCropAreaHeight(height);
            return this;
        }

        public ImageToPdfClient setRemoveBorders(boolean value) {
            this.fields.put("remove_borders", value ? "true" : null);
            return this;
        }

        public ImageToPdfClient setPageSize(String size) {
            if (!size.matches("(?i)^(A0|A1|A2|A3|A4|A5|A6|Letter)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(size, "setPageSize", "image-to-pdf", "Allowed values are A0, A1, A2, A3, A4, A5, A6, Letter.", "set_page_size"), 470);
            }
            this.fields.put("page_size", size);
            return this;
        }

        public ImageToPdfClient setPageWidth(String width) {
            if (!width.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(width, "setPageWidth", "image-to-pdf", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_page_width"), 470);
            }
            this.fields.put("page_width", width);
            return this;
        }

        public ImageToPdfClient setPageHeight(String height) {
            if (!height.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(height, "setPageHeight", "image-to-pdf", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_page_height"), 470);
            }
            this.fields.put("page_height", height);
            return this;
        }

        public ImageToPdfClient setPageDimensions(String width, String height) {
            this.setPageWidth(width);
            this.setPageHeight(height);
            return this;
        }

        public ImageToPdfClient setOrientation(String orientation) {
            if (!orientation.matches("(?i)^(landscape|portrait)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(orientation, "setOrientation", "image-to-pdf", "Allowed values are landscape, portrait.", "set_orientation"), 470);
            }
            this.fields.put("orientation", orientation);
            return this;
        }

        public ImageToPdfClient setPosition(String position) {
            if (!position.matches("(?i)^(center|top|bottom|left|right|top-left|top-right|bottom-left|bottom-right)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(position, "setPosition", "image-to-pdf", "Allowed values are center, top, bottom, left, right, top-left, top-right, bottom-left, bottom-right.", "set_position"), 470);
            }
            this.fields.put("position", position);
            return this;
        }

        public ImageToPdfClient setPrintPageMode(String mode) {
            if (!mode.matches("(?i)^(default|fit|stretch)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(mode, "setPrintPageMode", "image-to-pdf", "Allowed values are default, fit, stretch.", "set_print_page_mode"), 470);
            }
            this.fields.put("print_page_mode", mode);
            return this;
        }

        public ImageToPdfClient setMarginTop(String top) {
            if (!top.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(top, "setMarginTop", "image-to-pdf", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_margin_top"), 470);
            }
            this.fields.put("margin_top", top);
            return this;
        }

        public ImageToPdfClient setMarginRight(String right) {
            if (!right.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(right, "setMarginRight", "image-to-pdf", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_margin_right"), 470);
            }
            this.fields.put("margin_right", right);
            return this;
        }

        public ImageToPdfClient setMarginBottom(String bottom) {
            if (!bottom.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(bottom, "setMarginBottom", "image-to-pdf", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_margin_bottom"), 470);
            }
            this.fields.put("margin_bottom", bottom);
            return this;
        }

        public ImageToPdfClient setMarginLeft(String left) {
            if (!left.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(left, "setMarginLeft", "image-to-pdf", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_margin_left"), 470);
            }
            this.fields.put("margin_left", left);
            return this;
        }

        public ImageToPdfClient setPageMargins(String top, String right, String bottom, String left) {
            this.setMarginTop(top);
            this.setMarginRight(right);
            this.setMarginBottom(bottom);
            this.setMarginLeft(left);
            return this;
        }

        public ImageToPdfClient setPageBackgroundColor(String color) {
            if (!color.matches("^[0-9a-fA-F]{6,8}$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(color, "setPageBackgroundColor", "image-to-pdf", "The value must be in RRGGBB or RRGGBBAA hexadecimal format.", "set_page_background_color"), 470);
            }
            this.fields.put("page_background_color", color);
            return this;
        }

        public ImageToPdfClient setDpi(int dpi) {
            this.fields.put("dpi", Integer.toString(dpi));
            return this;
        }

        public ImageToPdfClient setPageWatermark(String watermark) {
            if (new File(watermark).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(watermark, "setPageWatermark", "image-to-pdf", "The file must exist and not be empty.", "set_page_watermark"), 470);
            }
            this.files.put("page_watermark", watermark);
            return this;
        }

        public ImageToPdfClient setPageWatermarkUrl(String url) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "setPageWatermarkUrl", "image-to-pdf", "Supported protocols are http:// and https://.", "set_page_watermark_url"), 470);
            }
            this.fields.put("page_watermark_url", url);
            return this;
        }

        public ImageToPdfClient setMultipageWatermark(String watermark) {
            if (new File(watermark).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(watermark, "setMultipageWatermark", "image-to-pdf", "The file must exist and not be empty.", "set_multipage_watermark"), 470);
            }
            this.files.put("multipage_watermark", watermark);
            return this;
        }

        public ImageToPdfClient setMultipageWatermarkUrl(String url) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "setMultipageWatermarkUrl", "image-to-pdf", "Supported protocols are http:// and https://.", "set_multipage_watermark_url"), 470);
            }
            this.fields.put("multipage_watermark_url", url);
            return this;
        }

        public ImageToPdfClient setPageBackground(String background) {
            if (new File(background).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(background, "setPageBackground", "image-to-pdf", "The file must exist and not be empty.", "set_page_background"), 470);
            }
            this.files.put("page_background", background);
            return this;
        }

        public ImageToPdfClient setPageBackgroundUrl(String url) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "setPageBackgroundUrl", "image-to-pdf", "Supported protocols are http:// and https://.", "set_page_background_url"), 470);
            }
            this.fields.put("page_background_url", url);
            return this;
        }

        public ImageToPdfClient setMultipageBackground(String background) {
            if (new File(background).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(background, "setMultipageBackground", "image-to-pdf", "The file must exist and not be empty.", "set_multipage_background"), 470);
            }
            this.files.put("multipage_background", background);
            return this;
        }

        public ImageToPdfClient setMultipageBackgroundUrl(String url) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "setMultipageBackgroundUrl", "image-to-pdf", "Supported protocols are http:// and https://.", "set_multipage_background_url"), 470);
            }
            this.fields.put("multipage_background_url", url);
            return this;
        }

        public ImageToPdfClient setLinearize(boolean value) {
            this.fields.put("linearize", value ? "true" : null);
            return this;
        }

        public ImageToPdfClient setEncrypt(boolean value) {
            this.fields.put("encrypt", value ? "true" : null);
            return this;
        }

        public ImageToPdfClient setUserPassword(String password) {
            this.fields.put("user_password", password);
            return this;
        }

        public ImageToPdfClient setOwnerPassword(String password) {
            this.fields.put("owner_password", password);
            return this;
        }

        public ImageToPdfClient setNoPrint(boolean value) {
            this.fields.put("no_print", value ? "true" : null);
            return this;
        }

        public ImageToPdfClient setNoModify(boolean value) {
            this.fields.put("no_modify", value ? "true" : null);
            return this;
        }

        public ImageToPdfClient setNoCopy(boolean value) {
            this.fields.put("no_copy", value ? "true" : null);
            return this;
        }

        public ImageToPdfClient setTitle(String title) {
            this.fields.put("title", title);
            return this;
        }

        public ImageToPdfClient setSubject(String subject) {
            this.fields.put("subject", subject);
            return this;
        }

        public ImageToPdfClient setAuthor(String author) {
            this.fields.put("author", author);
            return this;
        }

        public ImageToPdfClient setKeywords(String keywords) {
            this.fields.put("keywords", keywords);
            return this;
        }

        public ImageToPdfClient setPageLayout(String layout) {
            if (!layout.matches("(?i)^(single-page|one-column|two-column-left|two-column-right)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(layout, "setPageLayout", "image-to-pdf", "Allowed values are single-page, one-column, two-column-left, two-column-right.", "set_page_layout"), 470);
            }
            this.fields.put("page_layout", layout);
            return this;
        }

        public ImageToPdfClient setPageMode(String mode) {
            if (!mode.matches("(?i)^(full-screen|thumbnails|outlines)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(mode, "setPageMode", "image-to-pdf", "Allowed values are full-screen, thumbnails, outlines.", "set_page_mode"), 470);
            }
            this.fields.put("page_mode", mode);
            return this;
        }

        public ImageToPdfClient setInitialZoomType(String zoomType) {
            if (!zoomType.matches("(?i)^(fit-width|fit-height|fit-page)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(zoomType, "setInitialZoomType", "image-to-pdf", "Allowed values are fit-width, fit-height, fit-page.", "set_initial_zoom_type"), 470);
            }
            this.fields.put("initial_zoom_type", zoomType);
            return this;
        }

        public ImageToPdfClient setInitialPage(int page) {
            if (page <= 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(page, "setInitialPage", "image-to-pdf", "Must be a positive integer.", "set_initial_page"), 470);
            }
            this.fields.put("initial_page", Integer.toString(page));
            return this;
        }

        public ImageToPdfClient setInitialZoom(int zoom) {
            if (zoom <= 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(zoom, "setInitialZoom", "image-to-pdf", "Must be a positive integer.", "set_initial_zoom"), 470);
            }
            this.fields.put("initial_zoom", Integer.toString(zoom));
            return this;
        }

        public ImageToPdfClient setHideToolbar(boolean value) {
            this.fields.put("hide_toolbar", value ? "true" : null);
            return this;
        }

        public ImageToPdfClient setHideMenubar(boolean value) {
            this.fields.put("hide_menubar", value ? "true" : null);
            return this;
        }

        public ImageToPdfClient setHideWindowUi(boolean value) {
            this.fields.put("hide_window_ui", value ? "true" : null);
            return this;
        }

        public ImageToPdfClient setFitWindow(boolean value) {
            this.fields.put("fit_window", value ? "true" : null);
            return this;
        }

        public ImageToPdfClient setCenterWindow(boolean value) {
            this.fields.put("center_window", value ? "true" : null);
            return this;
        }

        public ImageToPdfClient setDisplayTitle(boolean value) {
            this.fields.put("display_title", value ? "true" : null);
            return this;
        }

        public ImageToPdfClient setDebugLog(boolean value) {
            this.fields.put("debug_log", value ? "true" : null);
            return this;
        }

        public String getDebugLogUrl() {
            return this.helper.getDebugLogUrl();
        }

        public int getRemainingCreditCount() {
            return this.helper.getRemainingCreditCount();
        }

        public int getConsumedCreditCount() {
            return this.helper.getConsumedCreditCount();
        }

        public String getJobId() {
            return this.helper.getJobId();
        }

        public int getOutputSize() {
            return this.helper.getOutputSize();
        }

        public String getVersion() {
            return String.format("client %s, API v2, converter %s", Pdfcrowd.CLIENT_VERSION, this.helper.getConverterVersion());
        }

        public ImageToPdfClient setTag(String tag) {
            this.fields.put("tag", tag);
            return this;
        }

        public ImageToPdfClient setHttpProxy(String proxy) {
            if (!proxy.matches("(?i)^([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z0-9]{1,}:\\d+$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(proxy, "setHttpProxy", "image-to-pdf", "The value must have format DOMAIN_OR_IP_ADDRESS:PORT.", "set_http_proxy"), 470);
            }
            this.fields.put("http_proxy", proxy);
            return this;
        }

        public ImageToPdfClient setHttpsProxy(String proxy) {
            if (!proxy.matches("(?i)^([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z0-9]{1,}:\\d+$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(proxy, "setHttpsProxy", "image-to-pdf", "The value must have format DOMAIN_OR_IP_ADDRESS:PORT.", "set_https_proxy"), 470);
            }
            this.fields.put("https_proxy", proxy);
            return this;
        }

        public ImageToPdfClient setConverterVersion(String version) {
            if (!version.matches("(?i)^(24.04|20.10|18.10|latest)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(version, "setConverterVersion", "image-to-pdf", "Allowed values are 24.04, 20.10, 18.10, latest.", "set_converter_version"), 470);
            }
            this.helper.setConverterVersion(version);
            return this;
        }

        public ImageToPdfClient setUseHttp(boolean value) {
            this.helper.setUseHttp(value);
            return this;
        }

        public ImageToPdfClient setClientUserAgent(String agent) {
            this.helper.setUserAgent(agent);
            return this;
        }

        public ImageToPdfClient setUserAgent(String agent) {
            this.helper.setUserAgent(agent);
            return this;
        }

        public ImageToPdfClient setProxy(String host, int port, String userName, String password) {
            this.helper.setProxy(host, port, userName, password);
            return this;
        }

        public ImageToPdfClient setRetryCount(int count) {
            this.helper.setRetryCount(count);
            return this;
        }
    }

    public static final class PdfToPdfClient {
        private ConnectionHelper helper;
        private HashMap<String, String> fields = new HashMap();
        private HashMap<String, String> files = new HashMap();
        private HashMap<String, byte[]> rawData = new HashMap();
        private int fileId = 1;

        public PdfToPdfClient(String userName, String apiKey) {
            this.helper = new ConnectionHelper(userName, apiKey);
            this.fields.put("input_format", "pdf");
            this.fields.put("output_format", "pdf");
        }

        public PdfToPdfClient setAction(String action) {
            if (!action.matches("(?i)^(join|shuffle|extract|delete)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(action, "setAction", "pdf-to-pdf", "Allowed values are join, shuffle, extract, delete.", "set_action"), 470);
            }
            this.fields.put("action", action);
            return this;
        }

        public byte[] convert() {
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertToStream(OutputStream outStream) {
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertToFile(String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertToFile", "pdf-to-pdf", "The string must not be empty.", "convert_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            this.convertToStream(outputFile);
            outputFile.close();
        }

        public PdfToPdfClient addPdfFile(String filePath) {
            if (new File(filePath).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "addPdfFile", "pdf-to-pdf", "The file must exist and not be empty.", "add_pdf_file"), 470);
            }
            this.files.put("f_" + Integer.toString(this.fileId), filePath);
            ++this.fileId;
            return this;
        }

        public PdfToPdfClient addPdfRawData(byte[] data) {
            if (data == null || data.length <= 300 || !new String(data, 0, 4).equals("%PDF")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage("raw PDF data", "addPdfRawData", "pdf-to-pdf", "The input data must be PDF content.", "add_pdf_raw_data"), 470);
            }
            this.rawData.put("f_" + Integer.toString(this.fileId), data);
            ++this.fileId;
            return this;
        }

        public PdfToPdfClient setInputPdfPassword(String password) {
            this.fields.put("input_pdf_password", password);
            return this;
        }

        public PdfToPdfClient setPageRange(String pages) {
            if (!pages.matches("^(?:\\s*(?:\\d+|(?:\\d*\\s*\\-\\s*\\d+)|(?:\\d+\\s*\\-\\s*\\d*))\\s*,\\s*)*\\s*(?:\\d+|(?:\\d*\\s*\\-\\s*\\d+)|(?:\\d+\\s*\\-\\s*\\d*))\\s*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(pages, "setPageRange", "pdf-to-pdf", "A comma separated list of page numbers or ranges.", "set_page_range"), 470);
            }
            this.fields.put("page_range", pages);
            return this;
        }

        public PdfToPdfClient setPageWatermark(String watermark) {
            if (new File(watermark).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(watermark, "setPageWatermark", "pdf-to-pdf", "The file must exist and not be empty.", "set_page_watermark"), 470);
            }
            this.files.put("page_watermark", watermark);
            return this;
        }

        public PdfToPdfClient setPageWatermarkUrl(String url) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "setPageWatermarkUrl", "pdf-to-pdf", "Supported protocols are http:// and https://.", "set_page_watermark_url"), 470);
            }
            this.fields.put("page_watermark_url", url);
            return this;
        }

        public PdfToPdfClient setMultipageWatermark(String watermark) {
            if (new File(watermark).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(watermark, "setMultipageWatermark", "pdf-to-pdf", "The file must exist and not be empty.", "set_multipage_watermark"), 470);
            }
            this.files.put("multipage_watermark", watermark);
            return this;
        }

        public PdfToPdfClient setMultipageWatermarkUrl(String url) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "setMultipageWatermarkUrl", "pdf-to-pdf", "Supported protocols are http:// and https://.", "set_multipage_watermark_url"), 470);
            }
            this.fields.put("multipage_watermark_url", url);
            return this;
        }

        public PdfToPdfClient setPageBackground(String background) {
            if (new File(background).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(background, "setPageBackground", "pdf-to-pdf", "The file must exist and not be empty.", "set_page_background"), 470);
            }
            this.files.put("page_background", background);
            return this;
        }

        public PdfToPdfClient setPageBackgroundUrl(String url) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "setPageBackgroundUrl", "pdf-to-pdf", "Supported protocols are http:// and https://.", "set_page_background_url"), 470);
            }
            this.fields.put("page_background_url", url);
            return this;
        }

        public PdfToPdfClient setMultipageBackground(String background) {
            if (new File(background).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(background, "setMultipageBackground", "pdf-to-pdf", "The file must exist and not be empty.", "set_multipage_background"), 470);
            }
            this.files.put("multipage_background", background);
            return this;
        }

        public PdfToPdfClient setMultipageBackgroundUrl(String url) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "setMultipageBackgroundUrl", "pdf-to-pdf", "Supported protocols are http:// and https://.", "set_multipage_background_url"), 470);
            }
            this.fields.put("multipage_background_url", url);
            return this;
        }

        public PdfToPdfClient setLinearize(boolean value) {
            this.fields.put("linearize", value ? "true" : null);
            return this;
        }

        public PdfToPdfClient setEncrypt(boolean value) {
            this.fields.put("encrypt", value ? "true" : null);
            return this;
        }

        public PdfToPdfClient setUserPassword(String password) {
            this.fields.put("user_password", password);
            return this;
        }

        public PdfToPdfClient setOwnerPassword(String password) {
            this.fields.put("owner_password", password);
            return this;
        }

        public PdfToPdfClient setNoPrint(boolean value) {
            this.fields.put("no_print", value ? "true" : null);
            return this;
        }

        public PdfToPdfClient setNoModify(boolean value) {
            this.fields.put("no_modify", value ? "true" : null);
            return this;
        }

        public PdfToPdfClient setNoCopy(boolean value) {
            this.fields.put("no_copy", value ? "true" : null);
            return this;
        }

        public PdfToPdfClient setTitle(String title) {
            this.fields.put("title", title);
            return this;
        }

        public PdfToPdfClient setSubject(String subject) {
            this.fields.put("subject", subject);
            return this;
        }

        public PdfToPdfClient setAuthor(String author) {
            this.fields.put("author", author);
            return this;
        }

        public PdfToPdfClient setKeywords(String keywords) {
            this.fields.put("keywords", keywords);
            return this;
        }

        public PdfToPdfClient setUseMetadataFrom(int index) {
            if (index < 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(index, "setUseMetadataFrom", "pdf-to-pdf", "Must be a positive integer or 0.", "set_use_metadata_from"), 470);
            }
            this.fields.put("use_metadata_from", Integer.toString(index));
            return this;
        }

        public PdfToPdfClient setPageLayout(String layout) {
            if (!layout.matches("(?i)^(single-page|one-column|two-column-left|two-column-right)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(layout, "setPageLayout", "pdf-to-pdf", "Allowed values are single-page, one-column, two-column-left, two-column-right.", "set_page_layout"), 470);
            }
            this.fields.put("page_layout", layout);
            return this;
        }

        public PdfToPdfClient setPageMode(String mode) {
            if (!mode.matches("(?i)^(full-screen|thumbnails|outlines)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(mode, "setPageMode", "pdf-to-pdf", "Allowed values are full-screen, thumbnails, outlines.", "set_page_mode"), 470);
            }
            this.fields.put("page_mode", mode);
            return this;
        }

        public PdfToPdfClient setInitialZoomType(String zoomType) {
            if (!zoomType.matches("(?i)^(fit-width|fit-height|fit-page)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(zoomType, "setInitialZoomType", "pdf-to-pdf", "Allowed values are fit-width, fit-height, fit-page.", "set_initial_zoom_type"), 470);
            }
            this.fields.put("initial_zoom_type", zoomType);
            return this;
        }

        public PdfToPdfClient setInitialPage(int page) {
            if (page <= 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(page, "setInitialPage", "pdf-to-pdf", "Must be a positive integer.", "set_initial_page"), 470);
            }
            this.fields.put("initial_page", Integer.toString(page));
            return this;
        }

        public PdfToPdfClient setInitialZoom(int zoom) {
            if (zoom <= 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(zoom, "setInitialZoom", "pdf-to-pdf", "Must be a positive integer.", "set_initial_zoom"), 470);
            }
            this.fields.put("initial_zoom", Integer.toString(zoom));
            return this;
        }

        public PdfToPdfClient setHideToolbar(boolean value) {
            this.fields.put("hide_toolbar", value ? "true" : null);
            return this;
        }

        public PdfToPdfClient setHideMenubar(boolean value) {
            this.fields.put("hide_menubar", value ? "true" : null);
            return this;
        }

        public PdfToPdfClient setHideWindowUi(boolean value) {
            this.fields.put("hide_window_ui", value ? "true" : null);
            return this;
        }

        public PdfToPdfClient setFitWindow(boolean value) {
            this.fields.put("fit_window", value ? "true" : null);
            return this;
        }

        public PdfToPdfClient setCenterWindow(boolean value) {
            this.fields.put("center_window", value ? "true" : null);
            return this;
        }

        public PdfToPdfClient setDisplayTitle(boolean value) {
            this.fields.put("display_title", value ? "true" : null);
            return this;
        }

        public PdfToPdfClient setRightToLeft(boolean value) {
            this.fields.put("right_to_left", value ? "true" : null);
            return this;
        }

        public PdfToPdfClient setDebugLog(boolean value) {
            this.fields.put("debug_log", value ? "true" : null);
            return this;
        }

        public String getDebugLogUrl() {
            return this.helper.getDebugLogUrl();
        }

        public int getRemainingCreditCount() {
            return this.helper.getRemainingCreditCount();
        }

        public int getConsumedCreditCount() {
            return this.helper.getConsumedCreditCount();
        }

        public String getJobId() {
            return this.helper.getJobId();
        }

        public int getPageCount() {
            return this.helper.getPageCount();
        }

        public int getOutputSize() {
            return this.helper.getOutputSize();
        }

        public String getVersion() {
            return String.format("client %s, API v2, converter %s", Pdfcrowd.CLIENT_VERSION, this.helper.getConverterVersion());
        }

        public PdfToPdfClient setTag(String tag) {
            this.fields.put("tag", tag);
            return this;
        }

        public PdfToPdfClient setConverterVersion(String version) {
            if (!version.matches("(?i)^(24.04|20.10|18.10|latest)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(version, "setConverterVersion", "pdf-to-pdf", "Allowed values are 24.04, 20.10, 18.10, latest.", "set_converter_version"), 470);
            }
            this.helper.setConverterVersion(version);
            return this;
        }

        public PdfToPdfClient setUseHttp(boolean value) {
            this.helper.setUseHttp(value);
            return this;
        }

        public PdfToPdfClient setClientUserAgent(String agent) {
            this.helper.setUserAgent(agent);
            return this;
        }

        public PdfToPdfClient setUserAgent(String agent) {
            this.helper.setUserAgent(agent);
            return this;
        }

        public PdfToPdfClient setProxy(String host, int port, String userName, String password) {
            this.helper.setProxy(host, port, userName, password);
            return this;
        }

        public PdfToPdfClient setRetryCount(int count) {
            this.helper.setRetryCount(count);
            return this;
        }
    }

    public static final class ImageToImageClient {
        private ConnectionHelper helper;
        private HashMap<String, String> fields = new HashMap();
        private HashMap<String, String> files = new HashMap();
        private HashMap<String, byte[]> rawData = new HashMap();
        private int fileId = 1;

        public ImageToImageClient(String userName, String apiKey) {
            this.helper = new ConnectionHelper(userName, apiKey);
            this.fields.put("input_format", "image");
            this.fields.put("output_format", "png");
        }

        public byte[] convertUrl(String url) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "convertUrl", "image-to-image", "Supported protocols are http:// and https://.", "convert_url"), 470);
            }
            this.fields.put("url", url);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertUrlToStream(String url, OutputStream outStream) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "convertUrlToStream::url", "image-to-image", "Supported protocols are http:// and https://.", "convert_url_to_stream"), 470);
            }
            this.fields.put("url", url);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertUrlToFile(String url, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertUrlToFile::file_path", "image-to-image", "The string must not be empty.", "convert_url_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertUrlToStream(url, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertFile(String file) {
            if (new File(file).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(file, "convertFile", "image-to-image", "The file must exist and not be empty.", "convert_file"), 470);
            }
            this.files.put("file", file);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertFileToStream(String file, OutputStream outStream) {
            if (new File(file).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(file, "convertFileToStream::file", "image-to-image", "The file must exist and not be empty.", "convert_file_to_stream"), 470);
            }
            this.files.put("file", file);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertFileToFile(String file, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertFileToFile::file_path", "image-to-image", "The string must not be empty.", "convert_file_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertFileToStream(file, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertRawData(byte[] data) {
            this.rawData.put("file", data);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertRawDataToStream(byte[] data, OutputStream outStream) {
            this.rawData.put("file", data);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertRawDataToFile(byte[] data, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertRawDataToFile::file_path", "image-to-image", "The string must not be empty.", "convert_raw_data_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertRawDataToStream(data, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertStream(InputStream inStream) throws IOException {
            this.rawData.put("stream", ConnectionHelper.getBytes(inStream));
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertStreamToStream(InputStream inStream, OutputStream outStream) throws IOException {
            this.rawData.put("stream", ConnectionHelper.getBytes(inStream));
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertStreamToFile(InputStream inStream, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertStreamToFile::file_path", "image-to-image", "The string must not be empty.", "convert_stream_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertStreamToStream(inStream, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public ImageToImageClient setOutputFormat(String outputFormat) {
            if (!outputFormat.matches("(?i)^(png|jpg|gif|tiff|bmp|ico|ppm|pgm|pbm|pnm|psb|pct|ras|tga|sgi|sun|webp)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(outputFormat, "setOutputFormat", "image-to-image", "Allowed values are png, jpg, gif, tiff, bmp, ico, ppm, pgm, pbm, pnm, psb, pct, ras, tga, sgi, sun, webp.", "set_output_format"), 470);
            }
            this.fields.put("output_format", outputFormat);
            return this;
        }

        public ImageToImageClient setResize(String resize) {
            this.fields.put("resize", resize);
            return this;
        }

        public ImageToImageClient setRotate(String rotate) {
            this.fields.put("rotate", rotate);
            return this;
        }

        public ImageToImageClient setCropAreaX(String x) {
            if (!x.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(x, "setCropAreaX", "image-to-image", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_crop_area_x"), 470);
            }
            this.fields.put("crop_area_x", x);
            return this;
        }

        public ImageToImageClient setCropAreaY(String y) {
            if (!y.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(y, "setCropAreaY", "image-to-image", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_crop_area_y"), 470);
            }
            this.fields.put("crop_area_y", y);
            return this;
        }

        public ImageToImageClient setCropAreaWidth(String width) {
            if (!width.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(width, "setCropAreaWidth", "image-to-image", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_crop_area_width"), 470);
            }
            this.fields.put("crop_area_width", width);
            return this;
        }

        public ImageToImageClient setCropAreaHeight(String height) {
            if (!height.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(height, "setCropAreaHeight", "image-to-image", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_crop_area_height"), 470);
            }
            this.fields.put("crop_area_height", height);
            return this;
        }

        public ImageToImageClient setCropArea(String x, String y, String width, String height) {
            this.setCropAreaX(x);
            this.setCropAreaY(y);
            this.setCropAreaWidth(width);
            this.setCropAreaHeight(height);
            return this;
        }

        public ImageToImageClient setRemoveBorders(boolean value) {
            this.fields.put("remove_borders", value ? "true" : null);
            return this;
        }

        public ImageToImageClient setCanvasSize(String size) {
            if (!size.matches("(?i)^(A0|A1|A2|A3|A4|A5|A6|Letter)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(size, "setCanvasSize", "image-to-image", "Allowed values are A0, A1, A2, A3, A4, A5, A6, Letter.", "set_canvas_size"), 470);
            }
            this.fields.put("canvas_size", size);
            return this;
        }

        public ImageToImageClient setCanvasWidth(String width) {
            if (!width.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(width, "setCanvasWidth", "image-to-image", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_canvas_width"), 470);
            }
            this.fields.put("canvas_width", width);
            return this;
        }

        public ImageToImageClient setCanvasHeight(String height) {
            if (!height.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(height, "setCanvasHeight", "image-to-image", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_canvas_height"), 470);
            }
            this.fields.put("canvas_height", height);
            return this;
        }

        public ImageToImageClient setCanvasDimensions(String width, String height) {
            this.setCanvasWidth(width);
            this.setCanvasHeight(height);
            return this;
        }

        public ImageToImageClient setOrientation(String orientation) {
            if (!orientation.matches("(?i)^(landscape|portrait)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(orientation, "setOrientation", "image-to-image", "Allowed values are landscape, portrait.", "set_orientation"), 470);
            }
            this.fields.put("orientation", orientation);
            return this;
        }

        public ImageToImageClient setPosition(String position) {
            if (!position.matches("(?i)^(center|top|bottom|left|right|top-left|top-right|bottom-left|bottom-right)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(position, "setPosition", "image-to-image", "Allowed values are center, top, bottom, left, right, top-left, top-right, bottom-left, bottom-right.", "set_position"), 470);
            }
            this.fields.put("position", position);
            return this;
        }

        public ImageToImageClient setPrintCanvasMode(String mode) {
            if (!mode.matches("(?i)^(default|fit|stretch)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(mode, "setPrintCanvasMode", "image-to-image", "Allowed values are default, fit, stretch.", "set_print_canvas_mode"), 470);
            }
            this.fields.put("print_canvas_mode", mode);
            return this;
        }

        public ImageToImageClient setMarginTop(String top) {
            if (!top.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(top, "setMarginTop", "image-to-image", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_margin_top"), 470);
            }
            this.fields.put("margin_top", top);
            return this;
        }

        public ImageToImageClient setMarginRight(String right) {
            if (!right.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(right, "setMarginRight", "image-to-image", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_margin_right"), 470);
            }
            this.fields.put("margin_right", right);
            return this;
        }

        public ImageToImageClient setMarginBottom(String bottom) {
            if (!bottom.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(bottom, "setMarginBottom", "image-to-image", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_margin_bottom"), 470);
            }
            this.fields.put("margin_bottom", bottom);
            return this;
        }

        public ImageToImageClient setMarginLeft(String left) {
            if (!left.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(left, "setMarginLeft", "image-to-image", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_margin_left"), 470);
            }
            this.fields.put("margin_left", left);
            return this;
        }

        public ImageToImageClient setMargins(String top, String right, String bottom, String left) {
            this.setMarginTop(top);
            this.setMarginRight(right);
            this.setMarginBottom(bottom);
            this.setMarginLeft(left);
            return this;
        }

        public ImageToImageClient setCanvasBackgroundColor(String color) {
            if (!color.matches("^[0-9a-fA-F]{6,8}$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(color, "setCanvasBackgroundColor", "image-to-image", "The value must be in RRGGBB or RRGGBBAA hexadecimal format.", "set_canvas_background_color"), 470);
            }
            this.fields.put("canvas_background_color", color);
            return this;
        }

        public ImageToImageClient setDpi(int dpi) {
            this.fields.put("dpi", Integer.toString(dpi));
            return this;
        }

        public ImageToImageClient setDebugLog(boolean value) {
            this.fields.put("debug_log", value ? "true" : null);
            return this;
        }

        public String getDebugLogUrl() {
            return this.helper.getDebugLogUrl();
        }

        public int getRemainingCreditCount() {
            return this.helper.getRemainingCreditCount();
        }

        public int getConsumedCreditCount() {
            return this.helper.getConsumedCreditCount();
        }

        public String getJobId() {
            return this.helper.getJobId();
        }

        public int getOutputSize() {
            return this.helper.getOutputSize();
        }

        public String getVersion() {
            return String.format("client %s, API v2, converter %s", Pdfcrowd.CLIENT_VERSION, this.helper.getConverterVersion());
        }

        public ImageToImageClient setTag(String tag) {
            this.fields.put("tag", tag);
            return this;
        }

        public ImageToImageClient setHttpProxy(String proxy) {
            if (!proxy.matches("(?i)^([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z0-9]{1,}:\\d+$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(proxy, "setHttpProxy", "image-to-image", "The value must have format DOMAIN_OR_IP_ADDRESS:PORT.", "set_http_proxy"), 470);
            }
            this.fields.put("http_proxy", proxy);
            return this;
        }

        public ImageToImageClient setHttpsProxy(String proxy) {
            if (!proxy.matches("(?i)^([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z0-9]{1,}:\\d+$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(proxy, "setHttpsProxy", "image-to-image", "The value must have format DOMAIN_OR_IP_ADDRESS:PORT.", "set_https_proxy"), 470);
            }
            this.fields.put("https_proxy", proxy);
            return this;
        }

        public ImageToImageClient setConverterVersion(String version) {
            if (!version.matches("(?i)^(24.04|20.10|18.10|latest)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(version, "setConverterVersion", "image-to-image", "Allowed values are 24.04, 20.10, 18.10, latest.", "set_converter_version"), 470);
            }
            this.helper.setConverterVersion(version);
            return this;
        }

        public ImageToImageClient setUseHttp(boolean value) {
            this.helper.setUseHttp(value);
            return this;
        }

        public ImageToImageClient setClientUserAgent(String agent) {
            this.helper.setUserAgent(agent);
            return this;
        }

        public ImageToImageClient setUserAgent(String agent) {
            this.helper.setUserAgent(agent);
            return this;
        }

        public ImageToImageClient setProxy(String host, int port, String userName, String password) {
            this.helper.setProxy(host, port, userName, password);
            return this;
        }

        public ImageToImageClient setRetryCount(int count) {
            this.helper.setRetryCount(count);
            return this;
        }
    }

    public static final class HtmlToImageClient {
        private ConnectionHelper helper;
        private HashMap<String, String> fields = new HashMap();
        private HashMap<String, String> files = new HashMap();
        private HashMap<String, byte[]> rawData = new HashMap();
        private int fileId = 1;

        public HtmlToImageClient(String userName, String apiKey) {
            this.helper = new ConnectionHelper(userName, apiKey);
            this.fields.put("input_format", "html");
            this.fields.put("output_format", "png");
        }

        public HtmlToImageClient setOutputFormat(String outputFormat) {
            if (!outputFormat.matches("(?i)^(png|jpg|gif|tiff|bmp|ico|ppm|pgm|pbm|pnm|psb|pct|ras|tga|sgi|sun|webp)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(outputFormat, "setOutputFormat", "html-to-image", "Allowed values are png, jpg, gif, tiff, bmp, ico, ppm, pgm, pbm, pnm, psb, pct, ras, tga, sgi, sun, webp.", "set_output_format"), 470);
            }
            this.fields.put("output_format", outputFormat);
            return this;
        }

        public byte[] convertUrl(String url) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "convertUrl", "html-to-image", "Supported protocols are http:// and https://.", "convert_url"), 470);
            }
            this.fields.put("url", url);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertUrlToStream(String url, OutputStream outStream) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "convertUrlToStream::url", "html-to-image", "Supported protocols are http:// and https://.", "convert_url_to_stream"), 470);
            }
            this.fields.put("url", url);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertUrlToFile(String url, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertUrlToFile::file_path", "html-to-image", "The string must not be empty.", "convert_url_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertUrlToStream(url, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertFile(String file) {
            if (new File(file).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(file, "convertFile", "html-to-image", "The file must exist and not be empty.", "convert_file"), 470);
            }
            this.files.put("file", file);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertFileToStream(String file, OutputStream outStream) {
            if (new File(file).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(file, "convertFileToStream::file", "html-to-image", "The file must exist and not be empty.", "convert_file_to_stream"), 470);
            }
            this.files.put("file", file);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertFileToFile(String file, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertFileToFile::file_path", "html-to-image", "The string must not be empty.", "convert_file_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertFileToStream(file, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertString(String text) {
            if (text == null || text.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(text, "convertString", "html-to-image", "The string must not be empty.", "convert_string"), 470);
            }
            this.fields.put("text", text);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertStringToStream(String text, OutputStream outStream) {
            if (text == null || text.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(text, "convertStringToStream::text", "html-to-image", "The string must not be empty.", "convert_string_to_stream"), 470);
            }
            this.fields.put("text", text);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertStringToFile(String text, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertStringToFile::file_path", "html-to-image", "The string must not be empty.", "convert_string_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertStringToStream(text, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertStream(InputStream inStream) throws IOException {
            this.rawData.put("stream", ConnectionHelper.getBytes(inStream));
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertStreamToStream(InputStream inStream, OutputStream outStream) throws IOException {
            this.rawData.put("stream", ConnectionHelper.getBytes(inStream));
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertStreamToFile(InputStream inStream, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertStreamToFile::file_path", "html-to-image", "The string must not be empty.", "convert_stream_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertStreamToStream(inStream, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public HtmlToImageClient setZipMainFilename(String filename) {
            this.fields.put("zip_main_filename", filename);
            return this;
        }

        public HtmlToImageClient setScreenshotWidth(int width) {
            if (width < 96 || width > 65000) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(width, "setScreenshotWidth", "html-to-image", "The accepted range is 96-65000.", "set_screenshot_width"), 470);
            }
            this.fields.put("screenshot_width", Integer.toString(width));
            return this;
        }

        public HtmlToImageClient setScreenshotHeight(int height) {
            if (height <= 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(height, "setScreenshotHeight", "html-to-image", "Must be a positive integer.", "set_screenshot_height"), 470);
            }
            this.fields.put("screenshot_height", Integer.toString(height));
            return this;
        }

        public HtmlToImageClient setScaleFactor(int factor) {
            if (factor <= 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(factor, "setScaleFactor", "html-to-image", "Must be a positive integer.", "set_scale_factor"), 470);
            }
            this.fields.put("scale_factor", Integer.toString(factor));
            return this;
        }

        public HtmlToImageClient setBackgroundColor(String color) {
            if (!color.matches("^[0-9a-fA-F]{6,8}$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(color, "setBackgroundColor", "html-to-image", "The value must be in RRGGBB or RRGGBBAA hexadecimal format.", "set_background_color"), 470);
            }
            this.fields.put("background_color", color);
            return this;
        }

        public HtmlToImageClient setUsePrintMedia(boolean value) {
            this.fields.put("use_print_media", value ? "true" : null);
            return this;
        }

        public HtmlToImageClient setNoBackground(boolean value) {
            this.fields.put("no_background", value ? "true" : null);
            return this;
        }

        public HtmlToImageClient setDisableJavascript(boolean value) {
            this.fields.put("disable_javascript", value ? "true" : null);
            return this;
        }

        public HtmlToImageClient setDisableImageLoading(boolean value) {
            this.fields.put("disable_image_loading", value ? "true" : null);
            return this;
        }

        public HtmlToImageClient setDisableRemoteFonts(boolean value) {
            this.fields.put("disable_remote_fonts", value ? "true" : null);
            return this;
        }

        public HtmlToImageClient setUseMobileUserAgent(boolean value) {
            this.fields.put("use_mobile_user_agent", value ? "true" : null);
            return this;
        }

        public HtmlToImageClient setLoadIframes(String iframes) {
            if (!iframes.matches("(?i)^(all|same-origin|none)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(iframes, "setLoadIframes", "html-to-image", "Allowed values are all, same-origin, none.", "set_load_iframes"), 470);
            }
            this.fields.put("load_iframes", iframes);
            return this;
        }

        public HtmlToImageClient setBlockAds(boolean value) {
            this.fields.put("block_ads", value ? "true" : null);
            return this;
        }

        public HtmlToImageClient setDefaultEncoding(String encoding) {
            this.fields.put("default_encoding", encoding);
            return this;
        }

        public HtmlToImageClient setLocale(String locale) {
            this.fields.put("locale", locale);
            return this;
        }

        public HtmlToImageClient setHttpAuthUserName(String userName) {
            this.fields.put("http_auth_user_name", userName);
            return this;
        }

        public HtmlToImageClient setHttpAuthPassword(String password) {
            this.fields.put("http_auth_password", password);
            return this;
        }

        public HtmlToImageClient setHttpAuth(String userName, String password) {
            this.setHttpAuthUserName(userName);
            this.setHttpAuthPassword(password);
            return this;
        }

        public HtmlToImageClient setCookies(String cookies) {
            this.fields.put("cookies", cookies);
            return this;
        }

        public HtmlToImageClient setVerifySslCertificates(boolean value) {
            this.fields.put("verify_ssl_certificates", value ? "true" : null);
            return this;
        }

        public HtmlToImageClient setFailOnMainUrlError(boolean failOnError) {
            this.fields.put("fail_on_main_url_error", failOnError ? "true" : null);
            return this;
        }

        public HtmlToImageClient setFailOnAnyUrlError(boolean failOnError) {
            this.fields.put("fail_on_any_url_error", failOnError ? "true" : null);
            return this;
        }

        public HtmlToImageClient setNoXpdfcrowdHeader(boolean value) {
            this.fields.put("no_xpdfcrowd_header", value ? "true" : null);
            return this;
        }

        public HtmlToImageClient setCustomCss(String css) {
            if (css == null || css.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(css, "setCustomCss", "html-to-image", "The string must not be empty.", "set_custom_css"), 470);
            }
            this.fields.put("custom_css", css);
            return this;
        }

        public HtmlToImageClient setCustomJavascript(String javascript) {
            if (javascript == null || javascript.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(javascript, "setCustomJavascript", "html-to-image", "The string must not be empty.", "set_custom_javascript"), 470);
            }
            this.fields.put("custom_javascript", javascript);
            return this;
        }

        public HtmlToImageClient setOnLoadJavascript(String javascript) {
            if (javascript == null || javascript.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(javascript, "setOnLoadJavascript", "html-to-image", "The string must not be empty.", "set_on_load_javascript"), 470);
            }
            this.fields.put("on_load_javascript", javascript);
            return this;
        }

        public HtmlToImageClient setCustomHttpHeader(String header) {
            if (!header.matches("^.+:.+$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(header, "setCustomHttpHeader", "html-to-image", "A string containing the header name and value separated by a colon.", "set_custom_http_header"), 470);
            }
            this.fields.put("custom_http_header", header);
            return this;
        }

        public HtmlToImageClient setJavascriptDelay(int delay) {
            if (delay < 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(delay, "setJavascriptDelay", "html-to-image", "Must be a positive integer or 0.", "set_javascript_delay"), 470);
            }
            this.fields.put("javascript_delay", Integer.toString(delay));
            return this;
        }

        public HtmlToImageClient setElementToConvert(String selectors) {
            if (selectors == null || selectors.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(selectors, "setElementToConvert", "html-to-image", "The string must not be empty.", "set_element_to_convert"), 470);
            }
            this.fields.put("element_to_convert", selectors);
            return this;
        }

        public HtmlToImageClient setElementToConvertMode(String mode) {
            if (!mode.matches("(?i)^(cut-out|remove-siblings|hide-siblings)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(mode, "setElementToConvertMode", "html-to-image", "Allowed values are cut-out, remove-siblings, hide-siblings.", "set_element_to_convert_mode"), 470);
            }
            this.fields.put("element_to_convert_mode", mode);
            return this;
        }

        public HtmlToImageClient setWaitForElement(String selectors) {
            if (selectors == null || selectors.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(selectors, "setWaitForElement", "html-to-image", "The string must not be empty.", "set_wait_for_element"), 470);
            }
            this.fields.put("wait_for_element", selectors);
            return this;
        }

        public HtmlToImageClient setAutoDetectElementToConvert(boolean value) {
            this.fields.put("auto_detect_element_to_convert", value ? "true" : null);
            return this;
        }

        public HtmlToImageClient setReadabilityEnhancements(String enhancements) {
            if (!enhancements.matches("(?i)^(none|readability-v1|readability-v2|readability-v3|readability-v4)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(enhancements, "setReadabilityEnhancements", "html-to-image", "Allowed values are none, readability-v1, readability-v2, readability-v3, readability-v4.", "set_readability_enhancements"), 470);
            }
            this.fields.put("readability_enhancements", enhancements);
            return this;
        }

        public HtmlToImageClient setDataString(String dataString) {
            this.fields.put("data_string", dataString);
            return this;
        }

        public HtmlToImageClient setDataFile(String dataFile) {
            this.files.put("data_file", dataFile);
            return this;
        }

        public HtmlToImageClient setDataFormat(String dataFormat) {
            if (!dataFormat.matches("(?i)^(auto|json|xml|yaml|csv)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(dataFormat, "setDataFormat", "html-to-image", "Allowed values are auto, json, xml, yaml, csv.", "set_data_format"), 470);
            }
            this.fields.put("data_format", dataFormat);
            return this;
        }

        public HtmlToImageClient setDataEncoding(String encoding) {
            this.fields.put("data_encoding", encoding);
            return this;
        }

        public HtmlToImageClient setDataIgnoreUndefined(boolean value) {
            this.fields.put("data_ignore_undefined", value ? "true" : null);
            return this;
        }

        public HtmlToImageClient setDataAutoEscape(boolean value) {
            this.fields.put("data_auto_escape", value ? "true" : null);
            return this;
        }

        public HtmlToImageClient setDataTrimBlocks(boolean value) {
            this.fields.put("data_trim_blocks", value ? "true" : null);
            return this;
        }

        public HtmlToImageClient setDataOptions(String options) {
            this.fields.put("data_options", options);
            return this;
        }

        public HtmlToImageClient setDebugLog(boolean value) {
            this.fields.put("debug_log", value ? "true" : null);
            return this;
        }

        public String getDebugLogUrl() {
            return this.helper.getDebugLogUrl();
        }

        public int getRemainingCreditCount() {
            return this.helper.getRemainingCreditCount();
        }

        public int getConsumedCreditCount() {
            return this.helper.getConsumedCreditCount();
        }

        public String getJobId() {
            return this.helper.getJobId();
        }

        public int getOutputSize() {
            return this.helper.getOutputSize();
        }

        public String getVersion() {
            return String.format("client %s, API v2, converter %s", Pdfcrowd.CLIENT_VERSION, this.helper.getConverterVersion());
        }

        public HtmlToImageClient setTag(String tag) {
            this.fields.put("tag", tag);
            return this;
        }

        public HtmlToImageClient setHttpProxy(String proxy) {
            if (!proxy.matches("(?i)^([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z0-9]{1,}:\\d+$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(proxy, "setHttpProxy", "html-to-image", "The value must have format DOMAIN_OR_IP_ADDRESS:PORT.", "set_http_proxy"), 470);
            }
            this.fields.put("http_proxy", proxy);
            return this;
        }

        public HtmlToImageClient setHttpsProxy(String proxy) {
            if (!proxy.matches("(?i)^([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z0-9]{1,}:\\d+$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(proxy, "setHttpsProxy", "html-to-image", "The value must have format DOMAIN_OR_IP_ADDRESS:PORT.", "set_https_proxy"), 470);
            }
            this.fields.put("https_proxy", proxy);
            return this;
        }

        public HtmlToImageClient setClientCertificate(String certificate) {
            if (new File(certificate).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(certificate, "setClientCertificate", "html-to-image", "The file must exist and not be empty.", "set_client_certificate"), 470);
            }
            this.files.put("client_certificate", certificate);
            return this;
        }

        public HtmlToImageClient setClientCertificatePassword(String password) {
            this.fields.put("client_certificate_password", password);
            return this;
        }

        public HtmlToImageClient setMaxLoadingTime(int maxTime) {
            if (maxTime < 10 || maxTime > 30) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(maxTime, "setMaxLoadingTime", "html-to-image", "The accepted range is 10-30.", "set_max_loading_time"), 470);
            }
            this.fields.put("max_loading_time", Integer.toString(maxTime));
            return this;
        }

        public HtmlToImageClient setSubprocessReferrer(String referrer) {
            this.fields.put("subprocess_referrer", referrer);
            return this;
        }

        public HtmlToImageClient setConverterUserAgent(String agent) {
            this.fields.put("converter_user_agent", agent);
            return this;
        }

        public HtmlToImageClient setConverterVersion(String version) {
            if (!version.matches("(?i)^(24.04|20.10|18.10|latest)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(version, "setConverterVersion", "html-to-image", "Allowed values are 24.04, 20.10, 18.10, latest.", "set_converter_version"), 470);
            }
            this.helper.setConverterVersion(version);
            return this;
        }

        public HtmlToImageClient setUseHttp(boolean value) {
            this.helper.setUseHttp(value);
            return this;
        }

        public HtmlToImageClient setClientUserAgent(String agent) {
            this.helper.setUserAgent(agent);
            return this;
        }

        public HtmlToImageClient setUserAgent(String agent) {
            this.helper.setUserAgent(agent);
            return this;
        }

        public HtmlToImageClient setProxy(String host, int port, String userName, String password) {
            this.helper.setProxy(host, port, userName, password);
            return this;
        }

        public HtmlToImageClient setRetryCount(int count) {
            this.helper.setRetryCount(count);
            return this;
        }
    }

    public static final class HtmlToPdfClient {
        private ConnectionHelper helper;
        private HashMap<String, String> fields = new HashMap();
        private HashMap<String, String> files = new HashMap();
        private HashMap<String, byte[]> rawData = new HashMap();
        private int fileId = 1;

        public HtmlToPdfClient(String userName, String apiKey) {
            this.helper = new ConnectionHelper(userName, apiKey);
            this.fields.put("input_format", "html");
            this.fields.put("output_format", "pdf");
        }

        public byte[] convertUrl(String url) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "convertUrl", "html-to-pdf", "Supported protocols are http:// and https://.", "convert_url"), 470);
            }
            this.fields.put("url", url);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertUrlToStream(String url, OutputStream outStream) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "convertUrlToStream::url", "html-to-pdf", "Supported protocols are http:// and https://.", "convert_url_to_stream"), 470);
            }
            this.fields.put("url", url);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertUrlToFile(String url, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertUrlToFile::file_path", "html-to-pdf", "The string must not be empty.", "convert_url_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertUrlToStream(url, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertFile(String file) {
            if (new File(file).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(file, "convertFile", "html-to-pdf", "The file must exist and not be empty.", "convert_file"), 470);
            }
            this.files.put("file", file);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertFileToStream(String file, OutputStream outStream) {
            if (new File(file).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(file, "convertFileToStream::file", "html-to-pdf", "The file must exist and not be empty.", "convert_file_to_stream"), 470);
            }
            this.files.put("file", file);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertFileToFile(String file, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertFileToFile::file_path", "html-to-pdf", "The string must not be empty.", "convert_file_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertFileToStream(file, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertString(String text) {
            if (text == null || text.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(text, "convertString", "html-to-pdf", "The string must not be empty.", "convert_string"), 470);
            }
            this.fields.put("text", text);
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertStringToStream(String text, OutputStream outStream) {
            if (text == null || text.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(text, "convertStringToStream::text", "html-to-pdf", "The string must not be empty.", "convert_string_to_stream"), 470);
            }
            this.fields.put("text", text);
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertStringToFile(String text, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertStringToFile::file_path", "html-to-pdf", "The string must not be empty.", "convert_string_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertStringToStream(text, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public byte[] convertStream(InputStream inStream) throws IOException {
            this.rawData.put("stream", ConnectionHelper.getBytes(inStream));
            return this.helper.post(this.fields, this.files, this.rawData, null);
        }

        public void convertStreamToStream(InputStream inStream, OutputStream outStream) throws IOException {
            this.rawData.put("stream", ConnectionHelper.getBytes(inStream));
            this.helper.post(this.fields, this.files, this.rawData, outStream);
        }

        public void convertStreamToFile(InputStream inStream, String filePath) throws IOException {
            if (filePath == null || filePath.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filePath, "convertStreamToFile::file_path", "html-to-pdf", "The string must not be empty.", "convert_stream_to_file"), 470);
            }
            FileOutputStream outputFile = new FileOutputStream(filePath);
            try {
                this.convertStreamToStream(inStream, outputFile);
                outputFile.close();
            }
            catch (Error why) {
                outputFile.close();
                new File(filePath).delete();
                throw why;
            }
        }

        public HtmlToPdfClient setZipMainFilename(String filename) {
            this.fields.put("zip_main_filename", filename);
            return this;
        }

        public HtmlToPdfClient setPageSize(String size) {
            if (!size.matches("(?i)^(A0|A1|A2|A3|A4|A5|A6|Letter)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(size, "setPageSize", "html-to-pdf", "Allowed values are A0, A1, A2, A3, A4, A5, A6, Letter.", "set_page_size"), 470);
            }
            this.fields.put("page_size", size);
            return this;
        }

        public HtmlToPdfClient setPageWidth(String width) {
            if (!width.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(width, "setPageWidth", "html-to-pdf", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_page_width"), 470);
            }
            this.fields.put("page_width", width);
            return this;
        }

        public HtmlToPdfClient setPageHeight(String height) {
            if (!height.matches("(?i)^0$|^\\-1$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(height, "setPageHeight", "html-to-pdf", "The value must be -1 or specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_page_height"), 470);
            }
            this.fields.put("page_height", height);
            return this;
        }

        public HtmlToPdfClient setPageDimensions(String width, String height) {
            this.setPageWidth(width);
            this.setPageHeight(height);
            return this;
        }

        public HtmlToPdfClient setOrientation(String orientation) {
            if (!orientation.matches("(?i)^(landscape|portrait)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(orientation, "setOrientation", "html-to-pdf", "Allowed values are landscape, portrait.", "set_orientation"), 470);
            }
            this.fields.put("orientation", orientation);
            return this;
        }

        public HtmlToPdfClient setMarginTop(String top) {
            if (!top.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(top, "setMarginTop", "html-to-pdf", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_margin_top"), 470);
            }
            this.fields.put("margin_top", top);
            return this;
        }

        public HtmlToPdfClient setMarginRight(String right) {
            if (!right.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(right, "setMarginRight", "html-to-pdf", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_margin_right"), 470);
            }
            this.fields.put("margin_right", right);
            return this;
        }

        public HtmlToPdfClient setMarginBottom(String bottom) {
            if (!bottom.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(bottom, "setMarginBottom", "html-to-pdf", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_margin_bottom"), 470);
            }
            this.fields.put("margin_bottom", bottom);
            return this;
        }

        public HtmlToPdfClient setMarginLeft(String left) {
            if (!left.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(left, "setMarginLeft", "html-to-pdf", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_margin_left"), 470);
            }
            this.fields.put("margin_left", left);
            return this;
        }

        public HtmlToPdfClient setNoMargins(boolean value) {
            this.fields.put("no_margins", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setPageMargins(String top, String right, String bottom, String left) {
            this.setMarginTop(top);
            this.setMarginRight(right);
            this.setMarginBottom(bottom);
            this.setMarginLeft(left);
            return this;
        }

        public HtmlToPdfClient setPrintPageRange(String pages) {
            if (!pages.matches("^(?:\\s*(?:\\d+|(?:\\d*\\s*\\-\\s*\\d+)|(?:\\d+\\s*\\-\\s*\\d*)|odd|even|last)\\s*,\\s*)*\\s*(?:\\d+|(?:\\d*\\s*\\-\\s*\\d+)|(?:\\d+\\s*\\-\\s*\\d*)|odd|even|last)\\s*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(pages, "setPrintPageRange", "html-to-pdf", "A comma separated list of page numbers or ranges. Special strings may be used, such as 'odd', 'even' and 'last'.", "set_print_page_range"), 470);
            }
            this.fields.put("print_page_range", pages);
            return this;
        }

        public HtmlToPdfClient setContentViewportWidth(String width) {
            if (!width.matches("(?i)^(balanced|small|medium|large|extra-large|[0-9]+(px)?)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(width, "setContentViewportWidth", "html-to-pdf", "The value must be 'balanced', 'small', 'medium', 'large', 'extra-large', or a number in the range 96-65000px.", "set_content_viewport_width"), 470);
            }
            this.fields.put("content_viewport_width", width);
            return this;
        }

        public HtmlToPdfClient setContentViewportHeight(String height) {
            if (!height.matches("(?i)^(auto|large|[0-9]+(px)?)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(height, "setContentViewportHeight", "html-to-pdf", "The value must be 'auto', 'large', or a number.", "set_content_viewport_height"), 470);
            }
            this.fields.put("content_viewport_height", height);
            return this;
        }

        public HtmlToPdfClient setContentFitMode(String mode) {
            if (!mode.matches("(?i)^(auto|smart-scaling|no-scaling|viewport-width|content-width|single-page|single-page-ratio)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(mode, "setContentFitMode", "html-to-pdf", "Allowed values are auto, smart-scaling, no-scaling, viewport-width, content-width, single-page, single-page-ratio.", "set_content_fit_mode"), 470);
            }
            this.fields.put("content_fit_mode", mode);
            return this;
        }

        public HtmlToPdfClient setRemoveBlankPages(String pages) {
            if (!pages.matches("(?i)^(trailing|all|none)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(pages, "setRemoveBlankPages", "html-to-pdf", "Allowed values are trailing, all, none.", "set_remove_blank_pages"), 470);
            }
            this.fields.put("remove_blank_pages", pages);
            return this;
        }

        public HtmlToPdfClient setHeaderUrl(String url) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "setHeaderUrl", "html-to-pdf", "Supported protocols are http:// and https://.", "set_header_url"), 470);
            }
            this.fields.put("header_url", url);
            return this;
        }

        public HtmlToPdfClient setHeaderHtml(String html) {
            if (html == null || html.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(html, "setHeaderHtml", "html-to-pdf", "The string must not be empty.", "set_header_html"), 470);
            }
            this.fields.put("header_html", html);
            return this;
        }

        public HtmlToPdfClient setHeaderHeight(String height) {
            if (!height.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(height, "setHeaderHeight", "html-to-pdf", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_header_height"), 470);
            }
            this.fields.put("header_height", height);
            return this;
        }

        public HtmlToPdfClient setZipHeaderFilename(String filename) {
            this.fields.put("zip_header_filename", filename);
            return this;
        }

        public HtmlToPdfClient setFooterUrl(String url) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "setFooterUrl", "html-to-pdf", "Supported protocols are http:// and https://.", "set_footer_url"), 470);
            }
            this.fields.put("footer_url", url);
            return this;
        }

        public HtmlToPdfClient setFooterHtml(String html) {
            if (html == null || html.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(html, "setFooterHtml", "html-to-pdf", "The string must not be empty.", "set_footer_html"), 470);
            }
            this.fields.put("footer_html", html);
            return this;
        }

        public HtmlToPdfClient setFooterHeight(String height) {
            if (!height.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(height, "setFooterHeight", "html-to-pdf", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_footer_height"), 470);
            }
            this.fields.put("footer_height", height);
            return this;
        }

        public HtmlToPdfClient setZipFooterFilename(String filename) {
            this.fields.put("zip_footer_filename", filename);
            return this;
        }

        public HtmlToPdfClient setNoHeaderFooterHorizontalMargins(boolean value) {
            this.fields.put("no_header_footer_horizontal_margins", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setExcludeHeaderOnPages(String pages) {
            if (!pages.matches("^(?:\\s*\\-?\\d+\\s*,)*\\s*\\-?\\d+\\s*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(pages, "setExcludeHeaderOnPages", "html-to-pdf", "A comma separated list of page numbers.", "set_exclude_header_on_pages"), 470);
            }
            this.fields.put("exclude_header_on_pages", pages);
            return this;
        }

        public HtmlToPdfClient setExcludeFooterOnPages(String pages) {
            if (!pages.matches("^(?:\\s*\\-?\\d+\\s*,)*\\s*\\-?\\d+\\s*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(pages, "setExcludeFooterOnPages", "html-to-pdf", "A comma separated list of page numbers.", "set_exclude_footer_on_pages"), 470);
            }
            this.fields.put("exclude_footer_on_pages", pages);
            return this;
        }

        public HtmlToPdfClient setHeaderFooterScaleFactor(int factor) {
            if (factor < 10 || factor > 500) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(factor, "setHeaderFooterScaleFactor", "html-to-pdf", "The accepted range is 10-500.", "set_header_footer_scale_factor"), 470);
            }
            this.fields.put("header_footer_scale_factor", Integer.toString(factor));
            return this;
        }

        public HtmlToPdfClient setPageNumberingOffset(int offset) {
            this.fields.put("page_numbering_offset", Integer.toString(offset));
            return this;
        }

        public HtmlToPdfClient setPageWatermark(String watermark) {
            if (new File(watermark).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(watermark, "setPageWatermark", "html-to-pdf", "The file must exist and not be empty.", "set_page_watermark"), 470);
            }
            this.files.put("page_watermark", watermark);
            return this;
        }

        public HtmlToPdfClient setPageWatermarkUrl(String url) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "setPageWatermarkUrl", "html-to-pdf", "Supported protocols are http:// and https://.", "set_page_watermark_url"), 470);
            }
            this.fields.put("page_watermark_url", url);
            return this;
        }

        public HtmlToPdfClient setMultipageWatermark(String watermark) {
            if (new File(watermark).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(watermark, "setMultipageWatermark", "html-to-pdf", "The file must exist and not be empty.", "set_multipage_watermark"), 470);
            }
            this.files.put("multipage_watermark", watermark);
            return this;
        }

        public HtmlToPdfClient setMultipageWatermarkUrl(String url) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "setMultipageWatermarkUrl", "html-to-pdf", "Supported protocols are http:// and https://.", "set_multipage_watermark_url"), 470);
            }
            this.fields.put("multipage_watermark_url", url);
            return this;
        }

        public HtmlToPdfClient setPageBackground(String background) {
            if (new File(background).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(background, "setPageBackground", "html-to-pdf", "The file must exist and not be empty.", "set_page_background"), 470);
            }
            this.files.put("page_background", background);
            return this;
        }

        public HtmlToPdfClient setPageBackgroundUrl(String url) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "setPageBackgroundUrl", "html-to-pdf", "Supported protocols are http:// and https://.", "set_page_background_url"), 470);
            }
            this.fields.put("page_background_url", url);
            return this;
        }

        public HtmlToPdfClient setMultipageBackground(String background) {
            if (new File(background).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(background, "setMultipageBackground", "html-to-pdf", "The file must exist and not be empty.", "set_multipage_background"), 470);
            }
            this.files.put("multipage_background", background);
            return this;
        }

        public HtmlToPdfClient setMultipageBackgroundUrl(String url) {
            if (!url.matches("(?i)^https?://.*$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(url, "setMultipageBackgroundUrl", "html-to-pdf", "Supported protocols are http:// and https://.", "set_multipage_background_url"), 470);
            }
            this.fields.put("multipage_background_url", url);
            return this;
        }

        public HtmlToPdfClient setPageBackgroundColor(String color) {
            if (!color.matches("^[0-9a-fA-F]{6,8}$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(color, "setPageBackgroundColor", "html-to-pdf", "The value must be in RRGGBB or RRGGBBAA hexadecimal format.", "set_page_background_color"), 470);
            }
            this.fields.put("page_background_color", color);
            return this;
        }

        public HtmlToPdfClient setUsePrintMedia(boolean value) {
            this.fields.put("use_print_media", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setNoBackground(boolean value) {
            this.fields.put("no_background", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setDisableJavascript(boolean value) {
            this.fields.put("disable_javascript", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setDisableImageLoading(boolean value) {
            this.fields.put("disable_image_loading", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setDisableRemoteFonts(boolean value) {
            this.fields.put("disable_remote_fonts", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setUseMobileUserAgent(boolean value) {
            this.fields.put("use_mobile_user_agent", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setLoadIframes(String iframes) {
            if (!iframes.matches("(?i)^(all|same-origin|none)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(iframes, "setLoadIframes", "html-to-pdf", "Allowed values are all, same-origin, none.", "set_load_iframes"), 470);
            }
            this.fields.put("load_iframes", iframes);
            return this;
        }

        public HtmlToPdfClient setBlockAds(boolean value) {
            this.fields.put("block_ads", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setDefaultEncoding(String encoding) {
            this.fields.put("default_encoding", encoding);
            return this;
        }

        public HtmlToPdfClient setLocale(String locale) {
            this.fields.put("locale", locale);
            return this;
        }

        public HtmlToPdfClient setHttpAuthUserName(String userName) {
            this.fields.put("http_auth_user_name", userName);
            return this;
        }

        public HtmlToPdfClient setHttpAuthPassword(String password) {
            this.fields.put("http_auth_password", password);
            return this;
        }

        public HtmlToPdfClient setHttpAuth(String userName, String password) {
            this.setHttpAuthUserName(userName);
            this.setHttpAuthPassword(password);
            return this;
        }

        public HtmlToPdfClient setCookies(String cookies) {
            this.fields.put("cookies", cookies);
            return this;
        }

        public HtmlToPdfClient setVerifySslCertificates(boolean value) {
            this.fields.put("verify_ssl_certificates", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setFailOnMainUrlError(boolean failOnError) {
            this.fields.put("fail_on_main_url_error", failOnError ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setFailOnAnyUrlError(boolean failOnError) {
            this.fields.put("fail_on_any_url_error", failOnError ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setNoXpdfcrowdHeader(boolean value) {
            this.fields.put("no_xpdfcrowd_header", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setCssPageRuleMode(String mode) {
            if (!mode.matches("(?i)^(default|mode1|mode2)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(mode, "setCssPageRuleMode", "html-to-pdf", "Allowed values are default, mode1, mode2.", "set_css_page_rule_mode"), 470);
            }
            this.fields.put("css_page_rule_mode", mode);
            return this;
        }

        public HtmlToPdfClient setCustomCss(String css) {
            if (css == null || css.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(css, "setCustomCss", "html-to-pdf", "The string must not be empty.", "set_custom_css"), 470);
            }
            this.fields.put("custom_css", css);
            return this;
        }

        public HtmlToPdfClient setCustomJavascript(String javascript) {
            if (javascript == null || javascript.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(javascript, "setCustomJavascript", "html-to-pdf", "The string must not be empty.", "set_custom_javascript"), 470);
            }
            this.fields.put("custom_javascript", javascript);
            return this;
        }

        public HtmlToPdfClient setOnLoadJavascript(String javascript) {
            if (javascript == null || javascript.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(javascript, "setOnLoadJavascript", "html-to-pdf", "The string must not be empty.", "set_on_load_javascript"), 470);
            }
            this.fields.put("on_load_javascript", javascript);
            return this;
        }

        public HtmlToPdfClient setCustomHttpHeader(String header) {
            if (!header.matches("^.+:.+$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(header, "setCustomHttpHeader", "html-to-pdf", "A string containing the header name and value separated by a colon.", "set_custom_http_header"), 470);
            }
            this.fields.put("custom_http_header", header);
            return this;
        }

        public HtmlToPdfClient setJavascriptDelay(int delay) {
            if (delay < 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(delay, "setJavascriptDelay", "html-to-pdf", "Must be a positive integer or 0.", "set_javascript_delay"), 470);
            }
            this.fields.put("javascript_delay", Integer.toString(delay));
            return this;
        }

        public HtmlToPdfClient setElementToConvert(String selectors) {
            if (selectors == null || selectors.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(selectors, "setElementToConvert", "html-to-pdf", "The string must not be empty.", "set_element_to_convert"), 470);
            }
            this.fields.put("element_to_convert", selectors);
            return this;
        }

        public HtmlToPdfClient setElementToConvertMode(String mode) {
            if (!mode.matches("(?i)^(cut-out|remove-siblings|hide-siblings)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(mode, "setElementToConvertMode", "html-to-pdf", "Allowed values are cut-out, remove-siblings, hide-siblings.", "set_element_to_convert_mode"), 470);
            }
            this.fields.put("element_to_convert_mode", mode);
            return this;
        }

        public HtmlToPdfClient setWaitForElement(String selectors) {
            if (selectors == null || selectors.isEmpty()) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(selectors, "setWaitForElement", "html-to-pdf", "The string must not be empty.", "set_wait_for_element"), 470);
            }
            this.fields.put("wait_for_element", selectors);
            return this;
        }

        public HtmlToPdfClient setAutoDetectElementToConvert(boolean value) {
            this.fields.put("auto_detect_element_to_convert", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setReadabilityEnhancements(String enhancements) {
            if (!enhancements.matches("(?i)^(none|readability-v1|readability-v2|readability-v3|readability-v4)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(enhancements, "setReadabilityEnhancements", "html-to-pdf", "Allowed values are none, readability-v1, readability-v2, readability-v3, readability-v4.", "set_readability_enhancements"), 470);
            }
            this.fields.put("readability_enhancements", enhancements);
            return this;
        }

        public HtmlToPdfClient setViewportWidth(int width) {
            if (width < 96 || width > 65000) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(width, "setViewportWidth", "html-to-pdf", "The accepted range is 96-65000.", "set_viewport_width"), 470);
            }
            this.fields.put("viewport_width", Integer.toString(width));
            return this;
        }

        public HtmlToPdfClient setViewportHeight(int height) {
            if (height <= 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(height, "setViewportHeight", "html-to-pdf", "Must be a positive integer.", "set_viewport_height"), 470);
            }
            this.fields.put("viewport_height", Integer.toString(height));
            return this;
        }

        public HtmlToPdfClient setViewport(int width, int height) {
            this.setViewportWidth(width);
            this.setViewportHeight(height);
            return this;
        }

        public HtmlToPdfClient setRenderingMode(String mode) {
            if (!mode.matches("(?i)^(default|viewport)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(mode, "setRenderingMode", "html-to-pdf", "Allowed values are default, viewport.", "set_rendering_mode"), 470);
            }
            this.fields.put("rendering_mode", mode);
            return this;
        }

        public HtmlToPdfClient setSmartScalingMode(String mode) {
            if (!mode.matches("(?i)^(default|disabled|viewport-fit|content-fit|single-page-fit|single-page-fit-ex|mode1)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(mode, "setSmartScalingMode", "html-to-pdf", "Allowed values are default, disabled, viewport-fit, content-fit, single-page-fit, single-page-fit-ex, mode1.", "set_smart_scaling_mode"), 470);
            }
            this.fields.put("smart_scaling_mode", mode);
            return this;
        }

        public HtmlToPdfClient setScaleFactor(int factor) {
            if (factor < 10 || factor > 500) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(factor, "setScaleFactor", "html-to-pdf", "The accepted range is 10-500.", "set_scale_factor"), 470);
            }
            this.fields.put("scale_factor", Integer.toString(factor));
            return this;
        }

        public HtmlToPdfClient setJpegQuality(int quality) {
            if (quality < 1 || quality > 100) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(quality, "setJpegQuality", "html-to-pdf", "The accepted range is 1-100.", "set_jpeg_quality"), 470);
            }
            this.fields.put("jpeg_quality", Integer.toString(quality));
            return this;
        }

        public HtmlToPdfClient setConvertImagesToJpeg(String images) {
            if (!images.matches("(?i)^(none|opaque|all)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(images, "setConvertImagesToJpeg", "html-to-pdf", "Allowed values are none, opaque, all.", "set_convert_images_to_jpeg"), 470);
            }
            this.fields.put("convert_images_to_jpeg", images);
            return this;
        }

        public HtmlToPdfClient setImageDpi(int dpi) {
            if (dpi < 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(dpi, "setImageDpi", "html-to-pdf", "Must be a positive integer or 0.", "set_image_dpi"), 470);
            }
            this.fields.put("image_dpi", Integer.toString(dpi));
            return this;
        }

        public HtmlToPdfClient setEnablePdfForms(boolean value) {
            this.fields.put("enable_pdf_forms", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setLinearize(boolean value) {
            this.fields.put("linearize", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setEncrypt(boolean value) {
            this.fields.put("encrypt", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setUserPassword(String password) {
            this.fields.put("user_password", password);
            return this;
        }

        public HtmlToPdfClient setOwnerPassword(String password) {
            this.fields.put("owner_password", password);
            return this;
        }

        public HtmlToPdfClient setNoPrint(boolean value) {
            this.fields.put("no_print", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setNoModify(boolean value) {
            this.fields.put("no_modify", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setNoCopy(boolean value) {
            this.fields.put("no_copy", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setTitle(String title) {
            this.fields.put("title", title);
            return this;
        }

        public HtmlToPdfClient setSubject(String subject) {
            this.fields.put("subject", subject);
            return this;
        }

        public HtmlToPdfClient setAuthor(String author) {
            this.fields.put("author", author);
            return this;
        }

        public HtmlToPdfClient setKeywords(String keywords) {
            this.fields.put("keywords", keywords);
            return this;
        }

        public HtmlToPdfClient setExtractMetaTags(boolean value) {
            this.fields.put("extract_meta_tags", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setPageLayout(String layout) {
            if (!layout.matches("(?i)^(single-page|one-column|two-column-left|two-column-right)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(layout, "setPageLayout", "html-to-pdf", "Allowed values are single-page, one-column, two-column-left, two-column-right.", "set_page_layout"), 470);
            }
            this.fields.put("page_layout", layout);
            return this;
        }

        public HtmlToPdfClient setPageMode(String mode) {
            if (!mode.matches("(?i)^(full-screen|thumbnails|outlines)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(mode, "setPageMode", "html-to-pdf", "Allowed values are full-screen, thumbnails, outlines.", "set_page_mode"), 470);
            }
            this.fields.put("page_mode", mode);
            return this;
        }

        public HtmlToPdfClient setInitialZoomType(String zoomType) {
            if (!zoomType.matches("(?i)^(fit-width|fit-height|fit-page)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(zoomType, "setInitialZoomType", "html-to-pdf", "Allowed values are fit-width, fit-height, fit-page.", "set_initial_zoom_type"), 470);
            }
            this.fields.put("initial_zoom_type", zoomType);
            return this;
        }

        public HtmlToPdfClient setInitialPage(int page) {
            if (page <= 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(page, "setInitialPage", "html-to-pdf", "Must be a positive integer.", "set_initial_page"), 470);
            }
            this.fields.put("initial_page", Integer.toString(page));
            return this;
        }

        public HtmlToPdfClient setInitialZoom(int zoom) {
            if (zoom <= 0) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(zoom, "setInitialZoom", "html-to-pdf", "Must be a positive integer.", "set_initial_zoom"), 470);
            }
            this.fields.put("initial_zoom", Integer.toString(zoom));
            return this;
        }

        public HtmlToPdfClient setHideToolbar(boolean value) {
            this.fields.put("hide_toolbar", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setHideMenubar(boolean value) {
            this.fields.put("hide_menubar", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setHideWindowUi(boolean value) {
            this.fields.put("hide_window_ui", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setFitWindow(boolean value) {
            this.fields.put("fit_window", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setCenterWindow(boolean value) {
            this.fields.put("center_window", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setDisplayTitle(boolean value) {
            this.fields.put("display_title", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setRightToLeft(boolean value) {
            this.fields.put("right_to_left", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setDataString(String dataString) {
            this.fields.put("data_string", dataString);
            return this;
        }

        public HtmlToPdfClient setDataFile(String dataFile) {
            this.files.put("data_file", dataFile);
            return this;
        }

        public HtmlToPdfClient setDataFormat(String dataFormat) {
            if (!dataFormat.matches("(?i)^(auto|json|xml|yaml|csv)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(dataFormat, "setDataFormat", "html-to-pdf", "Allowed values are auto, json, xml, yaml, csv.", "set_data_format"), 470);
            }
            this.fields.put("data_format", dataFormat);
            return this;
        }

        public HtmlToPdfClient setDataEncoding(String encoding) {
            this.fields.put("data_encoding", encoding);
            return this;
        }

        public HtmlToPdfClient setDataIgnoreUndefined(boolean value) {
            this.fields.put("data_ignore_undefined", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setDataAutoEscape(boolean value) {
            this.fields.put("data_auto_escape", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setDataTrimBlocks(boolean value) {
            this.fields.put("data_trim_blocks", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setDataOptions(String options) {
            this.fields.put("data_options", options);
            return this;
        }

        public HtmlToPdfClient setDebugLog(boolean value) {
            this.fields.put("debug_log", value ? "true" : null);
            return this;
        }

        public String getDebugLogUrl() {
            return this.helper.getDebugLogUrl();
        }

        public int getRemainingCreditCount() {
            return this.helper.getRemainingCreditCount();
        }

        public int getConsumedCreditCount() {
            return this.helper.getConsumedCreditCount();
        }

        public String getJobId() {
            return this.helper.getJobId();
        }

        public int getPageCount() {
            return this.helper.getPageCount();
        }

        public int getTotalPageCount() {
            return this.helper.getTotalPageCount();
        }

        public int getOutputSize() {
            return this.helper.getOutputSize();
        }

        public String getVersion() {
            return String.format("client %s, API v2, converter %s", Pdfcrowd.CLIENT_VERSION, this.helper.getConverterVersion());
        }

        public HtmlToPdfClient setTag(String tag) {
            this.fields.put("tag", tag);
            return this;
        }

        public HtmlToPdfClient setHttpProxy(String proxy) {
            if (!proxy.matches("(?i)^([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z0-9]{1,}:\\d+$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(proxy, "setHttpProxy", "html-to-pdf", "The value must have format DOMAIN_OR_IP_ADDRESS:PORT.", "set_http_proxy"), 470);
            }
            this.fields.put("http_proxy", proxy);
            return this;
        }

        public HtmlToPdfClient setHttpsProxy(String proxy) {
            if (!proxy.matches("(?i)^([a-z0-9]+(-[a-z0-9]+)*\\.)+[a-z0-9]{1,}:\\d+$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(proxy, "setHttpsProxy", "html-to-pdf", "The value must have format DOMAIN_OR_IP_ADDRESS:PORT.", "set_https_proxy"), 470);
            }
            this.fields.put("https_proxy", proxy);
            return this;
        }

        public HtmlToPdfClient setClientCertificate(String certificate) {
            if (new File(certificate).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(certificate, "setClientCertificate", "html-to-pdf", "The file must exist and not be empty.", "set_client_certificate"), 470);
            }
            this.files.put("client_certificate", certificate);
            return this;
        }

        public HtmlToPdfClient setClientCertificatePassword(String password) {
            this.fields.put("client_certificate_password", password);
            return this;
        }

        public HtmlToPdfClient setLayoutDpi(int dpi) {
            if (dpi < 72 || dpi > 600) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(dpi, "setLayoutDpi", "html-to-pdf", "The accepted range is 72-600.", "set_layout_dpi"), 470);
            }
            this.fields.put("layout_dpi", Integer.toString(dpi));
            return this;
        }

        public HtmlToPdfClient setContentAreaX(String x) {
            if (!x.matches("(?i)^0$|^\\-?[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(x, "setContentAreaX", "html-to-pdf", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'. It may contain a negative value.", "set_content_area_x"), 470);
            }
            this.fields.put("content_area_x", x);
            return this;
        }

        public HtmlToPdfClient setContentAreaY(String y) {
            if (!y.matches("(?i)^0$|^\\-?[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(y, "setContentAreaY", "html-to-pdf", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'. It may contain a negative value.", "set_content_area_y"), 470);
            }
            this.fields.put("content_area_y", y);
            return this;
        }

        public HtmlToPdfClient setContentAreaWidth(String width) {
            if (!width.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(width, "setContentAreaWidth", "html-to-pdf", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_content_area_width"), 470);
            }
            this.fields.put("content_area_width", width);
            return this;
        }

        public HtmlToPdfClient setContentAreaHeight(String height) {
            if (!height.matches("(?i)^0$|^[0-9]*\\.?[0-9]+(pt|px|mm|cm|in)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(height, "setContentAreaHeight", "html-to-pdf", "The value must be specified in inches 'in', millimeters 'mm', centimeters 'cm', pixels 'px', or points 'pt'.", "set_content_area_height"), 470);
            }
            this.fields.put("content_area_height", height);
            return this;
        }

        public HtmlToPdfClient setContentArea(String x, String y, String width, String height) {
            this.setContentAreaX(x);
            this.setContentAreaY(y);
            this.setContentAreaWidth(width);
            this.setContentAreaHeight(height);
            return this;
        }

        public HtmlToPdfClient setContentsMatrix(String matrix) {
            this.fields.put("contents_matrix", matrix);
            return this;
        }

        public HtmlToPdfClient setHeaderMatrix(String matrix) {
            this.fields.put("header_matrix", matrix);
            return this;
        }

        public HtmlToPdfClient setFooterMatrix(String matrix) {
            this.fields.put("footer_matrix", matrix);
            return this;
        }

        public HtmlToPdfClient setDisablePageHeightOptimization(boolean value) {
            this.fields.put("disable_page_height_optimization", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setMainDocumentCssAnnotation(boolean value) {
            this.fields.put("main_document_css_annotation", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setHeaderFooterCssAnnotation(boolean value) {
            this.fields.put("header_footer_css_annotation", value ? "true" : null);
            return this;
        }

        public HtmlToPdfClient setMaxLoadingTime(int maxTime) {
            if (maxTime < 10 || maxTime > 30) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(maxTime, "setMaxLoadingTime", "html-to-pdf", "The accepted range is 10-30.", "set_max_loading_time"), 470);
            }
            this.fields.put("max_loading_time", Integer.toString(maxTime));
            return this;
        }

        public HtmlToPdfClient setConversionConfig(String jsonString) {
            this.fields.put("conversion_config", jsonString);
            return this;
        }

        public HtmlToPdfClient setConversionConfigFile(String filepath) {
            if (new File(filepath).length() <= 0L) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(filepath, "setConversionConfigFile", "html-to-pdf", "The file must exist and not be empty.", "set_conversion_config_file"), 470);
            }
            this.files.put("conversion_config_file", filepath);
            return this;
        }

        public HtmlToPdfClient setSubprocessReferrer(String referrer) {
            this.fields.put("subprocess_referrer", referrer);
            return this;
        }

        public HtmlToPdfClient setConverterUserAgent(String agent) {
            this.fields.put("converter_user_agent", agent);
            return this;
        }

        public HtmlToPdfClient setConverterVersion(String version) {
            if (!version.matches("(?i)^(24.04|20.10|18.10|latest)$")) {
                throw new Error(Pdfcrowd.createInvalidValueMessage(version, "setConverterVersion", "html-to-pdf", "Allowed values are 24.04, 20.10, 18.10, latest.", "set_converter_version"), 470);
            }
            this.helper.setConverterVersion(version);
            return this;
        }

        public HtmlToPdfClient setUseHttp(boolean value) {
            this.helper.setUseHttp(value);
            return this;
        }

        public HtmlToPdfClient setClientUserAgent(String agent) {
            this.helper.setUserAgent(agent);
            return this;
        }

        public HtmlToPdfClient setUserAgent(String agent) {
            this.helper.setUserAgent(agent);
            return this;
        }

        public HtmlToPdfClient setProxy(String host, int port, String userName, String password) {
            this.helper.setProxy(host, port, userName, password);
            return this;
        }

        public HtmlToPdfClient setRetryCount(int count) {
            this.helper.setRetryCount(count);
            return this;
        }
    }

    private static final class ConnectionHelper {
        private String userName;
        private String apiKey;
        private int port;
        private boolean useHttp;
        private String userAgent;
        private String debugLogUrl;
        private int credits;
        private int consumedCredits;
        private String jobId;
        private int pageCount;
        private int totalPageCount;
        private int outputSize;
        private String proxyHost;
        private int proxyPort;
        private String proxyUserName;
        private String proxyPassword;
        private int retryCount;
        private int retry;
        private String converterVersion;
        private static final HostnameVerifier HOSTNAME_VERIFIER = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return hostname.equals("api.pdfcrowd.com") || !HOST.equals("api.pdfcrowd.com");
            }
        };

        ConnectionHelper(String userName, String apiKey) {
            this.userName = userName;
            this.apiKey = apiKey;
            this.resetResponseData();
            this.setProxy(null, 0, null, null);
            this.setUseHttp(false);
            this.setUserAgent("pdfcrowd_java_client/6.5.3 (https://pdfcrowd.com)");
            this.retryCount = 1;
            this.converterVersion = "24.04";
        }

        private void resetResponseData() {
            this.debugLogUrl = null;
            this.credits = 999999;
            this.consumedCredits = 0;
            this.jobId = "";
            this.pageCount = 0;
            this.totalPageCount = 0;
            this.outputSize = 0;
            this.retry = 0;
        }

        private static byte[] getBytes(InputStream in) throws IOException {
            int bytesRead;
            if (in instanceof ByteArrayIOStream) {
                return ((ByteArrayIOStream)in).getBytes();
            }
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((bytesRead = in.read(buffer, 0, buffer.length)) != -1) {
                bytes.write(buffer, 0, bytesRead);
            }
            bytes.flush();
            return bytes.toByteArray();
        }

        private static void copyStream(InputStream in, OutputStream out) throws IOException {
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = in.read(buffer, 0, buffer.length)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
        }

        private static String join(AbstractCollection<String> col, String delimiter) {
            if (col.isEmpty()) {
                return "";
            }
            Iterator<String> iter = col.iterator();
            StringBuffer buffer = new StringBuffer(iter.next());
            while (iter.hasNext()) {
                buffer.append(delimiter).append(iter.next());
            }
            return buffer.toString();
        }

        private static HashMap<String, String> prepareFields(HashMap<String, String> fields) {
            HashMap<String, String> result = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : fields.entrySet()) {
                String value = entry.getValue();
                if (value == null || value.isEmpty()) continue;
                result.put(entry.getKey(), value);
            }
            return result;
        }

        byte[] post(HashMap<String, String> fields, HashMap<String, String> files, HashMap<String, byte[]> rawData, OutputStream outStream) {
            ByteArrayOutputStream body = ConnectionHelper.encodeMultipartPostData(ConnectionHelper.prepareFields(fields), files, rawData);
            String contentType = "multipart/form-data; boundary=----------ThIs_Is_tHe_bOUnDary_$";
            return this.doPost(body, contentType, outStream);
        }

        private static void beginFileField(String name, String fileName, Vector<String> body) {
            body.add("------------ThIs_Is_tHe_bOUnDary_$");
            body.add(String.format("Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"", name, fileName));
            body.add("Content-Type: application/octet-stream");
            body.add("");
            body.add("");
        }

        private static ByteArrayOutputStream encodeMultipartPostData(HashMap<String, String> fields, HashMap<String, String> files, HashMap<String, byte[]> rawData) {
            try {
                Vector<String> body = new Vector<String>();
                ByteArrayOutputStream retval = new ByteArrayOutputStream();
                for (Map.Entry<String, String> entry : fields.entrySet()) {
                    body.add("------------ThIs_Is_tHe_bOUnDary_$");
                    body.add(String.format("Content-Disposition: form-data; name=\"%s\"", entry.getKey()));
                    body.add("");
                    body.add(entry.getValue());
                }
                for (Map.Entry<String, String> entry : files.entrySet()) {
                    ConnectionHelper.beginFileField(entry.getKey(), entry.getValue(), body);
                    retval.write(ConnectionHelper.join(body, "\r\n").getBytes("UTF-8"));
                    body.clear();
                    ConnectionHelper.copyStream(new FileInputStream(entry.getValue()), retval);
                    retval.write("\r\n".getBytes("UTF-8"));
                }
                for (Map.Entry<String, String> entry : rawData.entrySet()) {
                    ConnectionHelper.beginFileField(entry.getKey(), entry.getKey(), body);
                    retval.write(ConnectionHelper.join(body, "\r\n").getBytes("UTF-8"));
                    body.clear();
                    retval.write((byte[])entry.getValue());
                    retval.write("\r\n".getBytes("UTF-8"));
                }
                body.add("------------ThIs_Is_tHe_bOUnDary_$--");
                body.add("");
                retval.write(ConnectionHelper.join(body, "\r\n").getBytes("UTF-8"));
                return retval;
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }

        private HttpURLConnection getConnection(String contentType) throws IOException {
            try {
                URL url = new URL(String.format("http%s://%s:%d%s%s/", this.useHttp ? "" : "s", HOST, this.port, "/convert/", this.converterVersion));
                HttpURLConnection conn = null;
                if (this.proxyHost != null) {
                    Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, this.proxyPort));
                    conn = (HttpURLConnection)url.openConnection(proxy);
                    if (this.proxyUserName != null) {
                        Authenticator authenticator = new Authenticator(){

                            @Override
                            public PasswordAuthentication getPasswordAuthentication() {
                                return new PasswordAuthentication(ConnectionHelper.this.proxyUserName, ConnectionHelper.this.proxyPassword.toCharArray());
                            }
                        };
                        Authenticator.setDefault(authenticator);
                    }
                } else {
                    conn = (HttpURLConnection)url.openConnection();
                    if (!this.useHttp && conn instanceof HttpsURLConnection) {
                        HttpsURLConnection ssl_conn = (HttpsURLConnection)conn;
                        ssl_conn.setHostnameVerifier(HOSTNAME_VERIFIER);
                    }
                }
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", contentType);
                conn.setRequestProperty("User-Agent", this.userAgent);
                String auth = this.userName + ':' + this.apiKey;
                String authEncoded = new String(Base64Utils.encodeBytes(auth.getBytes()));
                conn.setRequestProperty("Authorization", "Basic " + authEncoded);
                return conn;
            }
            catch (MalformedURLException e) {
                throw new Error(e);
            }
        }

        private static int getIntHeader(HttpURLConnection conn, String name, int defaultValue) {
            String value = conn.getHeaderField(name);
            return value == null ? defaultValue : Integer.parseInt(value);
        }

        private static String getStringHeader(HttpURLConnection conn, String name, String defaultValue) {
            String value = conn.getHeaderField(name);
            return value == null ? defaultValue : value;
        }

        private byte[] doPost(Object body, String contentType, OutputStream outStream) {
            if (!this.useHttp && this.proxyHost != null) {
                throw new Error("HTTPS over a proxy is not supported.");
            }
            this.resetResponseData();
            while (true) {
                try {
                    return this.execRequest(body, contentType, outStream);
                }
                catch (Error err) {
                    if ((err.getStatusCode() == 502 || err.getStatusCode() == 503) && this.retryCount > this.retry) {
                        ++this.retry;
                        try {
                            Thread.sleep(this.retry * 100);
                        }
                        catch (InterruptedException e) {
                            throw err;
                        }
                        continue;
                    }
                    throw err;
                }
                break;
            }
        }

        private byte[] execRequest(Object body, String contentType, OutputStream outStream) {
            try {
                int bytesRead;
                HttpURLConnection conn = this.getConnection(contentType);
                OutputStream wr = conn.getOutputStream();
                if (body instanceof byte[]) {
                    wr.write((byte[])body);
                } else {
                    ((ByteArrayOutputStream)body).writeTo(wr);
                }
                wr.flush();
                wr.close();
                this.debugLogUrl = ConnectionHelper.getStringHeader(conn, "X-Pdfcrowd-Debug-Log", "");
                this.credits = ConnectionHelper.getIntHeader(conn, "X-Pdfcrowd-Remaining-Credits", 999999);
                this.consumedCredits = ConnectionHelper.getIntHeader(conn, "X-Pdfcrowd-Consumed-Credits", 0);
                this.jobId = ConnectionHelper.getStringHeader(conn, "X-Pdfcrowd-Job-Id", "");
                this.pageCount = ConnectionHelper.getIntHeader(conn, "X-Pdfcrowd-Pages", 0);
                this.totalPageCount = ConnectionHelper.getIntHeader(conn, "X-Pdfcrowd-Total-Pages", 0);
                this.outputSize = ConnectionHelper.getIntHeader(conn, "X-Pdfcrowd-Output-Size", 0);
                if (conn.getResponseCode() > 299) {
                    String errMsg;
                    if (conn.getErrorStream() != null) {
                        ByteArrayOutputStream errOut = new ByteArrayOutputStream();
                        ConnectionHelper.copyStream(conn.getErrorStream(), errOut);
                        errMsg = errOut.toString();
                    } else {
                        errMsg = conn.getResponseMessage();
                    }
                    throw new Error(errMsg, conn.getResponseCode());
                }
                InputStream inStream = conn.getInputStream();
                if (outStream != null) {
                    ConnectionHelper.copyStream(inStream, outStream);
                    inStream.close();
                    return null;
                }
                byte[] buffer = new byte[16384];
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                while ((bytesRead = inStream.read(buffer)) != -1) {
                    output.write(buffer, 0, bytesRead);
                }
                inStream.close();
                return output.toByteArray();
            }
            catch (SSLException e) {
                throw new Error("400.356 - There was a problem connecting to PDFCrowd servers over HTTPS:\n" + e.toString() + "\nYou can still use the API over HTTP, you just need to add the following line right after PDFCrowd client initialization:\nclient.setUseHttp(true);", 0);
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }

        void setUseHttp(boolean useHttp) {
            this.useHttp = useHttp;
            this.port = useHttp ? 80 : 443;
        }

        void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        void setRetryCount(int retryCount) {
            this.retryCount = retryCount;
        }

        void setConverterVersion(String converterVersion) {
            this.converterVersion = converterVersion;
        }

        void setProxy(String host, int port, String userName, String password) {
            this.proxyHost = host;
            this.proxyPort = port;
            this.proxyUserName = userName;
            this.proxyPassword = password;
        }

        String getDebugLogUrl() {
            return this.debugLogUrl;
        }

        int getRemainingCreditCount() {
            return this.credits;
        }

        int getConsumedCreditCount() {
            return this.consumedCredits;
        }

        String getJobId() {
            return this.jobId;
        }

        int getPageCount() {
            return this.pageCount;
        }

        int getTotalPageCount() {
            return this.totalPageCount;
        }

        int getOutputSize() {
            return this.outputSize;
        }

        String getConverterVersion() {
            return this.converterVersion;
        }
    }

    public static class ByteArrayIOStream
    extends InputStream {
        private ByteArrayOutputStream bytesStream = new ByteArrayOutputStream();

        public OutputStream getOutputStream() {
            return this.bytesStream;
        }

        public byte[] getBytes() {
            return this.bytesStream.toByteArray();
        }

        @Override
        public int read() {
            return -1;
        }
    }

    public static final class Error
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        public int statusCode = 0;
        private int reasonCode = -1;
        private String error;
        private String message;
        private String docLink;

        public Error() {
        }

        public Error(Throwable throwable) {
            super(throwable);
        }

        public Error(String msg) {
            this(msg, 0);
        }

        public Error(String msg, int code) {
            super(msg);
            this.error = msg;
            String pattern = "^(\\d+)\\.(\\d+)\\s+-\\s+(.*?)(?:\\s+Documentation link:\\s+(.*))?$";
            Pattern regex = Pattern.compile(pattern, 32);
            Matcher matcher = regex.matcher(msg);
            if (matcher.find()) {
                this.statusCode = Integer.parseInt(matcher.group(1));
                this.reasonCode = Integer.parseInt(matcher.group(2));
                this.message = matcher.group(3);
                this.docLink = matcher.group(4) != null ? matcher.group(4) : "";
            } else {
                this.statusCode = code;
                this.message = this.error;
                if (this.statusCode != 0) {
                    this.error = this.statusCode + " - " + msg;
                }
                this.docLink = "";
            }
        }

        @Override
        public String toString() {
            return this.error;
        }

        @Deprecated
        public int getCode() {
            System.err.println("[DEPRECATION] `getCode` is obsolete and will be removed in future versions. Use `getStatusCode` instead.");
            return this.statusCode;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public int getReasonCode() {
            return this.reasonCode;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public String getDocumentationLink() {
            return this.docLink;
        }
    }
}

